/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.vmware.cis.data.api.QueryService;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.NamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.data.BatchQueryPagingIterator;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import com.vmware.ph.phservice.collector.data.QueryExecutionEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryServiceCollector<OUT> {
    private static final Log _log = LogFactory.getLog(QueryServiceCollector.class);
    private final ResultIteratorFactory<OUT> _resultIteratorFactory;

    public QueryServiceCollector() {
        this(new ResultIteratorFactory());
    }

    QueryServiceCollector(ResultIteratorFactory<OUT> iteratorFactory) {
        this._resultIteratorFactory = iteratorFactory;
    }

    public Iterable<OUT> collect(NamedQuery[] queries, final NamedQueryResultSetMapping<OUT> responseMapping, final QueryService queryService, Context context, int pageSize) {
        final Context modifiedContext = new Context(context);
        if (ArrayUtils.isEmpty((Object[])queries)) {
            return Collections.emptyList();
        }
        Object[] queriesForExecution = QueryServiceCollector.filterQueriesForExecution(queryService, queries, responseMapping);
        if (ArrayUtils.isEmpty((Object[])queriesForExecution)) {
            return Collections.emptyList();
        }
        return new Iterable<OUT>((NamedQuery[])queriesForExecution, pageSize){
            final /* synthetic */ NamedQuery[] val$queriesForExecution;
            final /* synthetic */ int val$pageSize;
            {
                this.val$queriesForExecution = namedQueryArray;
                this.val$pageSize = n;
            }

            @Override
            public Iterator<OUT> iterator() {
                return QueryServiceCollector.this._resultIteratorFactory.getIterator(queryService, responseMapping, modifiedContext, this.val$queriesForExecution, this.val$pageSize);
            }
        };
    }

    private static NamedQuery[] filterQueriesForExecution(QueryService queryService, NamedQuery[] queries, NamedQueryResultSetMapping<?> responseMapping) {
        QueryExecutionEvaluator queryExecutionEvaluator = new QueryExecutionEvaluator(queryService);
        ArrayList<NamedQuery> queriesForExecution = new ArrayList<NamedQuery>(queries.length);
        for (int i = 0; i < queries.length; ++i) {
            NamedQuery query = queries[i];
            if (responseMapping.isQuerySupported(query.getName()) && queryExecutionEvaluator.shouldExecuteQuery(query)) {
                queriesForExecution.add(query);
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)String.format("Query [%s] was excluded from execution.", query.getName()));
        }
        return queriesForExecution.toArray(new NamedQuery[queriesForExecution.size()]);
    }

    static class ResultIteratorFactory<OUT> {
        ResultIteratorFactory() {
        }

        public Iterator<OUT> getIterator(final QueryService queryService, final Mapping<NamedQueryResultSet, OUT> responseMapping, final Context context, final NamedQuery[] queries, final int pageSize) {
            Iterable<NamedQueryResultSet> queryPagingIterable = new Iterable<NamedQueryResultSet>(){

                @Override
                public Iterator<NamedQueryResultSet> iterator() {
                    return new BatchQueryPagingIterator(queryService, queries, pageSize);
                }
            };
            Iterable responseMappingIterable = Iterables.transform((Iterable)queryPagingIterable, (Function)new Function<NamedQueryResultSet, OUT>(){

                public OUT apply(NamedQueryResultSet inputResultSet) {
                    Object result = responseMapping.map(inputResultSet, context);
                    return result;
                }
            });
            return responseMappingIterable.iterator();
        }
    }
}

