/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.manifest.xml.mapping;

import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import com.vmware.ph.phservice.collector.manifest.InvalidManifestException;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.MappingParser;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.IndependentResultsMapping;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.Mappings;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.ResourceItemToCdfFreeFormDataMapping;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.ResourceItemToCdfResourceMapping;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.ResourceItemToJsonLdMapping;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.ResourceItemToJsonLdWithAttributesPatternMapping;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.ResultSetToCdfPayloadMapping;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxbCdfMappingParser
implements MappingParser {
    private static JAXBContext _instance;
    private final JAXBContext _ctx;
    private final Unmarshaller _parser;

    static JAXBContext getInstance() throws JAXBException {
        if (_instance == null) {
            _instance = JAXBContext.newInstance((Class[])new Class[]{IndependentResultsMapping.class, ResultSetToCdfPayloadMapping.class, ResourceItemToCdfResourceMapping.class, ResourceItemToJsonLdMapping.class, ResourceItemToCdfFreeFormDataMapping.class, ResourceItemToJsonLdWithAttributesPatternMapping.class, Mappings.Wrapper.class});
        }
        return _instance;
    }

    public JaxbCdfMappingParser() {
        try {
            this._ctx = JaxbCdfMappingParser.getInstance();
            this._parser = this._ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new Bug("Bad hardcoded JAXB configuration.", (Throwable)e);
        }
    }

    public Mapping parse(Node xmlNode) {
        try {
            Node element = this.getFirstChildElement(xmlNode);
            if (element == null) {
                com.vmware.ph.phservice.collector.cdf.mapping.IndependentResultsMapping emptyMapping = IndependentResultsMapping.EMPTY_INDEPENDENT_RESULTS_MAPPING;
                return emptyMapping;
            }
            Object parsedObj = this._parser.unmarshal(element);
            if (!(parsedObj instanceof IndependentResultsMapping)) {
                throw new InvalidManifestException("Unexpected cdfMapping first child element in XML manifest.");
            }
            IndependentResultsMapping result = (IndependentResultsMapping)parsedObj;
            Mapping<NamedQueryResultSet, Payload20> cdfMapping = result.build();
            return cdfMapping;
        }
        catch (JAXBException e) {
            throw new InvalidManifestException("Failed parsing mapping from XML.", e);
        }
    }

    private Node getFirstChildElement(Node xmlNode) {
        NodeList children = xmlNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            return children.item(i);
        }
        return null;
    }
}

