/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.manifest.xml.query;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.ComparisonOperator;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.FilterSpec;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.LogicalOperator;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.PropertyPredicate;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.PropertySpec;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.QuerySpec;
import java.util.ArrayList;
import java.util.List;

public class QueryUtils {
    public static NamedQuery viseQuerySpecToRiseQuery(QuerySpec viseQuerySpec) {
        String[] coreResourceModels = new String[]{viseQuerySpec.getConstraint().targetType};
        List<String> coreProperties = QueryUtils.toCoreProperties(viseQuerySpec.getPropertySpecs());
        int coreOffset = 0;
        int coreLimit = -1;
        if (null != viseQuerySpec.getMaxResultCount()) {
            coreLimit = viseQuerySpec.getMaxResultCount();
        }
        Filter coreFilter = QueryUtils.toCoreFilter(viseQuerySpec.getFilter());
        Query.Builder riseQueryBuilder = Query.Builder.select(coreProperties).from(coreResourceModels).offset(coreOffset).limit(coreLimit).where(coreFilter).orderBy("@modelKey");
        if (coreLimit == 0 || coreLimit == -1) {
            riseQueryBuilder.withTotalCount();
        }
        Query riseQuery = riseQueryBuilder.build();
        return new NamedQuery(riseQuery, viseQuerySpec.getName(), viseQuerySpec.getCpuThreshold(), viseQuerySpec.getMemoryThreshold());
    }

    private static List<String> toCoreProperties(List<PropertySpec> viseProperties) {
        ArrayList<String> coreProperties = new ArrayList<String>();
        coreProperties.add("@modelKey");
        if (viseProperties != null && viseProperties.size() > 0) {
            String[] visePropertyNames;
            for (String visePropertyName : visePropertyNames = viseProperties.get((int)0).propertyNames) {
                String corePropertyName = visePropertyName.replaceAll("\\.", "/");
                if (corePropertyName.endsWith("_length")) {
                    corePropertyName = corePropertyName.replaceAll("_length", "length");
                }
                coreProperties.add(corePropertyName);
            }
        }
        return coreProperties;
    }

    private static Filter toCoreFilter(FilterSpec filter) {
        Filter coreFilter = null;
        if (filter != null && filter.getCriteria() != null) {
            List<com.vmware.cis.data.api.PropertyPredicate> coreCriteria = QueryUtils.toCoreCriteria(filter.getCriteria());
            if (filter.getOperator() != null) {
                com.vmware.cis.data.api.LogicalOperator logicalOperator = QueryUtils.toCoreLogicalOperator(filter.getOperator());
                coreFilter = new Filter(coreCriteria, logicalOperator);
            } else {
                coreFilter = new Filter(coreCriteria);
            }
        }
        return coreFilter;
    }

    private static List<com.vmware.cis.data.api.PropertyPredicate> toCoreCriteria(List<PropertyPredicate> predicates) {
        ArrayList<com.vmware.cis.data.api.PropertyPredicate> coreCriteria = new ArrayList<com.vmware.cis.data.api.PropertyPredicate>(predicates.size());
        for (PropertyPredicate predicate : predicates) {
            PropertyPredicate.ComparisonOperator comparisonOperator = QueryUtils.toCoreComparisonOperator(predicate.getOperator());
            coreCriteria.add(new com.vmware.cis.data.api.PropertyPredicate(predicate.getProperty(), comparisonOperator, predicate.getComparableValue(), predicate.isIgnoreCase()));
        }
        return coreCriteria;
    }

    private static com.vmware.cis.data.api.LogicalOperator toCoreLogicalOperator(LogicalOperator logicalOperator) {
        com.vmware.cis.data.api.LogicalOperator coreLogicalOperator = null;
        switch (logicalOperator) {
            case AND: {
                coreLogicalOperator = com.vmware.cis.data.api.LogicalOperator.AND;
                break;
            }
            case OR: {
                coreLogicalOperator = com.vmware.cis.data.api.LogicalOperator.OR;
            }
        }
        return coreLogicalOperator;
    }

    private static PropertyPredicate.ComparisonOperator toCoreComparisonOperator(ComparisonOperator comparisonOperator) {
        PropertyPredicate.ComparisonOperator coreComparisonOperator = null;
        if (comparisonOperator == null) {
            throw new IllegalArgumentException("Invalid comparison operator.");
        }
        switch (comparisonOperator) {
            case EQUAL: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.NOT_EQUAL;
                break;
            }
            case GREATER: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.GREATER;
                break;
            }
            case GREATER_OR_EQUAL: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL;
                break;
            }
            case LESS: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.LESS;
                break;
            }
            case LESS_OR_EQUAL: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL;
                break;
            }
            case IN: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.IN;
                break;
            }
            case NOT_IN: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.NOT_IN;
                break;
            }
            case LIKE: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.LIKE;
                break;
            }
            case UNSET: {
                coreComparisonOperator = PropertyPredicate.ComparisonOperator.UNSET;
            }
        }
        return coreComparisonOperator;
    }
}

