/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.product.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.collector.core.Collector;
import com.vmware.ph.phservice.collector.product.DataProvidersConnectionFactory;
import com.vmware.ph.phservice.collector.product.ProductCollectorCallback;
import com.vmware.ph.phservice.collector.product.ProductCollectorExceptionHandler;
import com.vmware.ph.phservice.collector.product.ProductCollectorExceptionHandlerFactory;
import com.vmware.ph.phservice.collector.product.ProductCollectorScheduler;
import com.vmware.ph.phservice.collector.product.ProductEndpoint;
import com.vmware.ph.phservice.collector.product.impl.ProductCollectorImpl;
import com.vmware.ph.phservice.collector.product.impl.ResultWrapperFuture;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PeriodicProductCollectorSchedulerImpl
implements ProductCollectorScheduler {
    private static final Log log = LogFactory.getLog(PeriodicProductCollectorSchedulerImpl.class);
    private final ScheduledExecutorService _executorService;
    private final int _collectionIntervalMinutes;
    private final ManifestContentProvider _manifestContentProvider;
    private final DataProvidersConnectionFactory _dataProvidersConnectionFactory;
    private final Map<ProductEndpoint, Future<?>> _endpointToFutureMap;
    private final ProductCollectorExceptionHandlerFactory _exceptionHandlerFactory;
    private final Map<ProductEndpoint, Collector> _endpointToCollectorMap;

    public PeriodicProductCollectorSchedulerImpl(Properties configurationProperties, int threadPoolSize, int collectionIntervalMinutes, ProductCollectorExceptionHandlerFactory exceptionHandlerFactory, ManifestContentProvider manifestContentProvider, DataProvidersConnectionFactory dataProvidersConnectionFactory) {
        Validate.notNull((Object)configurationProperties);
        Validate.isTrue((threadPoolSize > 0 ? 1 : 0) != 0);
        Validate.isTrue((collectionIntervalMinutes > 0 ? 1 : 0) != 0);
        Validate.notNull((Object)exceptionHandlerFactory);
        Validate.notNull((Object)manifestContentProvider);
        Validate.notNull((Object)dataProvidersConnectionFactory);
        ThreadFactory threadFactory = this.createThreadFactory();
        this._executorService = Executors.newScheduledThreadPool(threadPoolSize, threadFactory);
        this._collectionIntervalMinutes = collectionIntervalMinutes;
        this._endpointToFutureMap = new ConcurrentHashMap();
        this._exceptionHandlerFactory = exceptionHandlerFactory;
        this._manifestContentProvider = manifestContentProvider;
        this._dataProvidersConnectionFactory = dataProvidersConnectionFactory;
        this._endpointToCollectorMap = new ConcurrentHashMap<ProductEndpoint, Collector>();
    }

    private ThreadFactory createThreadFactory() {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setDaemon(true);
        builder.setNameFormat("ph-periodic-processor-thread-%d");
        return builder.build();
    }

    @Override
    public List<Future<?>> scheduleProductCollections(Collection<ProductEndpoint> endpoints, ProductCollectorCallback callback) {
        Validate.notEmpty(endpoints, (String)"The list of products shouldn't be empty.");
        Validate.notNull((Object)callback, (String)"The callback shouldn't be null");
        return this.scheduleProductCollections(endpoints, null, callback);
    }

    private List<Future<?>> scheduleProductCollections(Collection<ProductEndpoint> endpoints, PayloadUploader payloadUploader, ProductCollectorCallback callback) {
        LinkedList result = new LinkedList();
        for (ProductEndpoint endpoint : endpoints) {
            if (payloadUploader == null) {
                payloadUploader = this.createPayloadUploader(callback, endpoint);
            }
            DataProvidersConnection dataProvidersConnection = this._dataProvidersConnectionFactory.getDataProvidersConnection(endpoint);
            ProductCollectorExceptionHandler exceptionHandler = this._exceptionHandlerFactory.createCollectorExceptionHandler(endpoint);
            ProductCollectorImpl collector = new ProductCollectorImpl(dataProvidersConnection, this._manifestContentProvider, payloadUploader, exceptionHandler, endpoint);
            ScheduledFuture<?> scheduledFuture = this._executorService.scheduleAtFixedRate(collector, 0L, this._collectionIntervalMinutes, TimeUnit.MINUTES);
            this._endpointToFutureMap.put(endpoint, scheduledFuture);
            this._endpointToCollectorMap.put(endpoint, collector);
            exceptionHandler.setCollectorTask(scheduledFuture);
            result.add(scheduledFuture);
        }
        return result;
    }

    private PayloadUploader createPayloadUploader(final ProductCollectorCallback callback, final ProductEndpoint product) {
        PayloadUploader payloadUploader = new PayloadUploader(){

            @Override
            public Future<?> uploadPayload(Payload20 payload, PayloadEnvelope envelope, String uploadId) {
                callback.onPayloadRecieved(payload, product);
                return new ResultWrapperFuture<Payload20>(payload);
            }

            @Override
            public Future<?> uploadFile(String collectorId, String instanceId, String uploadId, File fileToUpload) {
                return null;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        };
        return payloadUploader;
    }

    @Override
    public void scheduleProductCollection(ProductEndpoint endpoint, ProductCollectorCallback callback) {
        this.scheduleProductCollections(Arrays.asList(endpoint), callback);
    }

    @Override
    public void cancelProductCollection(ProductEndpoint endpoint) {
        Collector collector;
        Future<?> future;
        Validate.notNull((Object)endpoint, (String)"The endpoint parameter cannot be null.");
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancelling product collection for " + endpoint));
        }
        if ((future = this._endpointToFutureMap.remove(endpoint)) != null) {
            future.cancel(false);
        }
        if ((collector = this._endpointToCollectorMap.remove(endpoint)) != null) {
            collector.close();
        }
    }

    @Override
    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)(PeriodicProductCollectorSchedulerImpl.class.getSimpleName() + ".close() was called"));
        }
        this._executorService.shutdownNow();
        Iterator<Collector> iter = this._endpointToCollectorMap.values().iterator();
        while (iter.hasNext()) {
            Collector collector = iter.next();
            iter.remove();
            collector.close();
        }
        try {
            this._executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Timeout while waiting for all the running collections to complete.", (Throwable)e);
        }
    }
}

