/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.product.impl;

import com.vmware.ph.phservice.collector.product.DataProvidersConnectionFactory;
import com.vmware.ph.phservice.collector.product.ProductCollectorExceptionHandler;
import com.vmware.ph.phservice.collector.product.ProductCollectorExceptionHandlerFactory;
import com.vmware.ph.phservice.collector.product.ProductCollectorScheduler;
import com.vmware.ph.phservice.collector.product.ProductEndpoint;
import com.vmware.ph.phservice.collector.product.impl.CancelationProductCollectorExceptionHandlerImpl;
import com.vmware.ph.phservice.collector.product.impl.PeriodicProductCollectorSchedulerImpl;
import com.vmware.ph.phservice.common.cdf.FileSystemManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import java.util.Properties;
import org.apache.commons.lang.Validate;

public final class ProductCollectorBuilder {
    private Properties _properties = new Properties();
    private int _threadPoolSize = 1;
    private int _collectionIntervalInMinutes = 60;
    private ProductCollectorExceptionHandlerFactory _exceptionHandlerFactory;
    private ManifestContentProvider _manifestContentProvider;
    private DataProvidersConnectionFactory _dataProvidersConnectionFactory;
    private int _maxRetries;

    public ProductCollectorBuilder withProperties(Properties properties) {
        this._properties = properties;
        return this;
    }

    public ProductCollectorBuilder withThreadPoolSize(int threadPoolSize) {
        Validate.isTrue((threadPoolSize > 0 ? 1 : 0) != 0, (String)"The thread pool size should be a non-null, positive integer.");
        this._threadPoolSize = threadPoolSize;
        return this;
    }

    public ProductCollectorBuilder withCollectionIntervalInMinutes(int collectionIntervalInMinutes) {
        Validate.isTrue((collectionIntervalInMinutes > 0 ? 1 : 0) != 0, (String)"The collection time interval should be a non-null, positive integer.");
        this._collectionIntervalInMinutes = collectionIntervalInMinutes;
        return this;
    }

    public ProductCollectorBuilder withPathToManifest(String pathToManifest) {
        Validate.notEmpty((String)pathToManifest);
        this._properties.setProperty("cmc.manifest_location", pathToManifest);
        this._manifestContentProvider = new FileSystemManifestContentProvider(pathToManifest);
        return this;
    }

    public ProductCollectorBuilder withExceptionHandlerFactory(ProductCollectorExceptionHandlerFactory exceptionHandlerFactory) {
        Validate.notNull((Object)exceptionHandlerFactory);
        this._exceptionHandlerFactory = exceptionHandlerFactory;
        return this;
    }

    public ProductCollectorBuilder withManifestContentProvider(ManifestContentProvider manifestContentProvider) {
        Validate.notNull((Object)manifestContentProvider);
        this._manifestContentProvider = manifestContentProvider;
        return this;
    }

    public ProductCollectorBuilder withDataProviders(DataProvidersConnectionFactory dataProvidersConnectionFactory) {
        Validate.notNull((Object)dataProvidersConnectionFactory);
        this._dataProvidersConnectionFactory = dataProvidersConnectionFactory;
        return this;
    }

    public ProductCollectorBuilder withMaxRetries(int maxRetries) {
        Validate.isTrue((maxRetries >= 0 ? 1 : 0) != 0);
        this._maxRetries = maxRetries;
        return this;
    }

    public ProductCollectorBuilder setProperty(String key, String value) {
        Validate.notEmpty((String)key, (String)"The property key shouldn't be empty.");
        this._properties.setProperty(key, value);
        return this;
    }

    public ProductCollectorScheduler buildPeriodicCollectorScheduler() {
        ProductCollectorExceptionHandlerFactory exceptionHandlerFactory = this._exceptionHandlerFactory;
        if (exceptionHandlerFactory == null) {
            exceptionHandlerFactory = new ProductCollectorExceptionHandlerFactory(){

                @Override
                public ProductCollectorExceptionHandler createCollectorExceptionHandler(ProductEndpoint endpoint) {
                    return new CancelationProductCollectorExceptionHandlerImpl(ProductCollectorBuilder.this._maxRetries);
                }
            };
        }
        return new PeriodicProductCollectorSchedulerImpl(this._properties, this._threadPoolSize, this._collectionIntervalInMinutes, exceptionHandlerFactory, this._manifestContentProvider, this._dataProvidersConnectionFactory);
    }
}

