/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler;

import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.CollectorOutcome;
import com.vmware.ph.phservice.collector.core.Collector;
import com.vmware.ph.phservice.collector.core.CollectorProvider;
import com.vmware.ph.phservice.collector.scheduler.CollectorActionCoordinator;
import com.vmware.ph.phservice.collector.scheduler.ConfigurationException;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CollectorAction
implements Callable<CollectorOutcome> {
    private static final String MSG_COLLECTION_START = "Collection process: started";
    private static final String MSG_COLLECTION_COMPLETED = "Collection process: completed";
    private static final Log _log = LogFactory.getLog(CollectorAction.class);
    private final CollectorActionCoordinator _actionCoordinator;
    private final CollectorProvider _collectorProvider;

    public CollectorAction(CollectorProvider collectorProvider, CollectorActionCoordinator actionCoordinator) {
        this._collectorProvider = collectorProvider;
        this._actionCoordinator = actionCoordinator;
    }

    @Override
    public CollectorOutcome call() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Starting the collection action.");
        }
        this._actionCoordinator.recordFirstBootTime(System.currentTimeMillis());
        CollectionPeriod failedCollection = null;
        CollectorOutcome outcome = this.attemptCollection(CollectionPeriod.DAILY);
        if (outcome == CollectorOutcome.PASSED) {
            outcome = this.attemptCollection(CollectionPeriod.WEEKLY);
            if (outcome != CollectorOutcome.PASSED) {
                failedCollection = CollectionPeriod.WEEKLY;
            }
        } else {
            failedCollection = CollectionPeriod.DAILY;
        }
        if (failedCollection != null && _log.isInfoEnabled()) {
            _log.info((Object)String.format("%s collection completed with error.", new Object[]{failedCollection}));
        }
        return outcome;
    }

    private CollectorOutcome attemptCollection(CollectionPeriod period) {
        try {
            CollectorOutcome outcome;
            boolean timeToFire = this._actionCoordinator.isItTimeToFire(period);
            if (timeToFire) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("It is time to run the " + (Object)((Object)period) + " data collection."));
                }
                outcome = this.performCollection(period);
                this._actionCoordinator.setLastCollectionTime(period, System.currentTimeMillis());
            } else {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Data collector doesn't yet need to run.");
                }
                outcome = CollectorOutcome.PASSED;
            }
            return outcome;
        }
        catch (ConfigurationException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error reading schedule configuration: " + e.getMessage()), (Throwable)e);
            }
            return CollectorOutcome.LOCAL_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectorOutcome performCollection(CollectionPeriod collectionPeriod) {
        try (Collector collector = null;){
            collector = this._collectorProvider.getCollector(collectionPeriod);
            if (collector == null) {
                CollectorOutcome collectorOutcome = CollectorOutcome.PASSED;
                return collectorOutcome;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)MSG_COLLECTION_START);
            }
            collector.run();
            if (_log.isInfoEnabled()) {
                _log.info((Object)MSG_COLLECTION_COMPLETED);
            }
            CollectorOutcome collectorOutcome = CollectorOutcome.PASSED;
            return collectorOutcome;
        }
    }
}

