/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler;

import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.phservice.CollectorOutcome;
import com.vmware.ph.phservice.collector.scheduler.CollectorLoop;
import com.vmware.ph.phservice.collector.scheduler.CollectorLoopExecutionConfigProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DefaultCollectorLoop
implements CollectorLoop {
    private static final long SETTINGS_CHECK_SECONDS = 60L;
    private static final Log _log = LogFactory.getLog(DefaultCollectorLoop.class);
    private final AtomicBoolean _mustStop = new AtomicBoolean(false);
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);
    private final CollectorLoopExecutionConfigProvider _collectorLoopExecutionConfigProvider;
    private final Callable<CollectorOutcome> _collectorAction;
    private Thread _collectorThread = null;
    private boolean _startMethodBeenExecuted = false;

    public DefaultCollectorLoop(CollectorLoopExecutionConfigProvider collectorLoopExecutionConfigProvider, Callable<CollectorOutcome> collectorAction) {
        this._collectorLoopExecutionConfigProvider = collectorLoopExecutionConfigProvider;
        this._collectorAction = collectorAction;
    }

    @Override
    public synchronized void start() {
        this._startMethodBeenExecuted = true;
        if (this._isRunning.get()) {
            throw new IllegalStateException();
        }
        final boolean runOnce = this._collectorLoopExecutionConfigProvider.shouldRunOnce();
        this._collectorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultCollectorLoop.this._isRunning.set(true);
                DefaultCollectorLoop.this.runLoop(runOnce);
            }
        }, "phservices-collector-thread");
        this._collectorThread.setDaemon(true);
        this._collectorThread.start();
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        if (this._collectorThread != null) {
            this._collectorThread.interrupt();
            this._collectorThread.join();
            this._collectorThread = null;
        }
    }

    @Override
    public synchronized void join() throws InterruptedException {
        if (this._collectorThread != null) {
            this._collectorThread.join();
        }
    }

    public synchronized boolean hasStartMethodBeenExecuted() {
        return this._startMethodBeenExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runLoop(boolean runOnce) {
        try {
            this.sleepInitialBackOff();
            while (!this._mustStop.get()) {
                outcome = CollectorOutcome.LOCAL_ERROR;
                try {
                    outcome = this._collectorAction.call();
                    if (runOnce) {
                        DefaultCollectorLoop._log.warn((Object)String.format("Stopping the %s, because it was forced to execute just once via property configuration.", new Object[]{this.getClass().getSimpleName()}));
                        this._mustStop.set(true);
                    }
                    ** GOTO lbl22
                }
                catch (Bug e) {
                    if (DefaultCollectorLoop._log.isErrorEnabled()) {
                        DefaultCollectorLoop._log.error((Object)String.format("BUG: An internal error has occurred: %s. Terminating the collector loop.", new Object[]{e.getMessage()}), (Throwable)e);
                    }
                    this._mustStop.set(true);
                    this._isRunning.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    try {
                        if (DefaultCollectorLoop._log.isWarnEnabled()) {
                            DefaultCollectorLoop._log.warn((Object)String.format("Unexpected runtime error escaping the collector loop. The current loop execution will not complete successfully. The loop is not terminated and the next collection attempt will be executed on schedule. For more details on the current error, see the underlying exception: %s: %s", new Object[]{e.getClass().getName(), e.getMessage()}), (Throwable)e);
                        }
                        outcome = CollectorOutcome.LOCAL_ERROR;
lbl22:
                        // 2 sources

                        this.sleep(outcome);
                    }
                    catch (InterruptedException e) {
                        if (DefaultCollectorLoop._log.isDebugEnabled()) {
                            DefaultCollectorLoop._log.debug((Object)"This thread received the interrupt signal (either due to stop() or container shutting down.) The caller needs us to stop.");
                        }
                        this._mustStop.set(true);
                        return;
                    }
                    catch (Exception e) {
                        if (!DefaultCollectorLoop._log.isErrorEnabled()) return;
                        DefaultCollectorLoop._log.error((Object)String.format("Collector terminated unexpectedly due to %s: %s", new Object[]{e.getClass().getName(), e.getMessage()}), (Throwable)e);
                        return;
                    }
                    catch (Throwable var4_7) {
                        throw var4_7;
                        return;
                    }
                }
            }
        }
        finally {
            this._isRunning.set(false);
        }
    }

    private void sleepInitialBackOff() throws InterruptedException {
        this.sleep(this._collectorLoopExecutionConfigProvider.getInitialBackOffTimeSeconds());
    }

    private void sleep(CollectorOutcome outcome) throws InterruptedException {
        long toSleep;
        long totalSeconds = this.calcSleepInterval(outcome);
        for (long timeSleptSeconds = 0L; timeSleptSeconds < totalSeconds && !this._mustStop.get(); timeSleptSeconds += toSleep) {
            toSleep = Math.min(totalSeconds - timeSleptSeconds, 60L);
            this.sleep(toSleep);
            totalSeconds = this.calcSleepInterval(outcome);
        }
    }

    private long calcSleepInterval(CollectorOutcome outcome) {
        long seconds;
        switch (outcome) {
            case PASSED: {
                seconds = this._collectorLoopExecutionConfigProvider.getScheduleCheckTimeSeconds();
                break;
            }
            default: {
                seconds = this._collectorLoopExecutionConfigProvider.getBackoffTimeSeconds();
            }
        }
        return seconds;
    }

    private void sleep(long sleepIntervalSeconds) throws InterruptedException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Sleeping for " + sleepIntervalSeconds + " seconds ..."));
        }
        Thread.sleep(sleepIntervalSeconds * 1000L);
    }
}

