/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler.impl;

import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.collector.scheduler.CollectorActionExecutionTracker;
import com.vmware.ph.phservice.common.PersistenceService;
import com.vmware.ph.phservice.common.PersistenceServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorActionExecutionTrackerImpl
implements CollectorActionExecutionTracker {
    private static final Log _log = LogFactory.getLog(CollectorActionExecutionTrackerImpl.class);
    private static final String KEY_PHSERVICES_WEEKLY_LAST_COLLECTION_TIME = "phservices.weekly.last_collection_time";
    private static final String KEY_PHSERVICES_DAILY_LAST_COLLECTION_TIME = "phservices.daily.last_collection_time";
    private final PersistenceService _persistenceService;

    public CollectorActionExecutionTrackerImpl(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    @Override
    public long getLastCollectionTime(CollectionPeriod collectionPeriod) {
        long result = 0L;
        try {
            Long value = this._persistenceService.readLong(CollectorActionExecutionTrackerImpl.constructLastCollectionTimeKey(collectionPeriod));
            if (value != null) {
                result = value;
            }
        }
        catch (PersistenceServiceException e) {
            _log.error((Object)"An exception occurred while trying to retrieve last collection time.", (Throwable)e);
        }
        return result;
    }

    @Override
    public void setLastCollectionTime(CollectionPeriod collectionPeriod, long firstBootTime) {
        try {
            this._persistenceService.writeLong(CollectorActionExecutionTrackerImpl.constructLastCollectionTimeKey(collectionPeriod), firstBootTime);
        }
        catch (PersistenceServiceException e) {
            _log.error((Object)"An exception occurred while trying to write last collection time.", (Throwable)e);
        }
    }

    private static String constructLastCollectionTimeKey(CollectionPeriod collectionPeriod) {
        if (collectionPeriod == CollectionPeriod.DAILY) {
            return KEY_PHSERVICES_DAILY_LAST_COLLECTION_TIME;
        }
        if (collectionPeriod == CollectionPeriod.WEEKLY) {
            return KEY_PHSERVICES_WEEKLY_LAST_COLLECTION_TIME;
        }
        throw new UnsupportedOperationException(String.format("%s enum has a value which is not supported by %s.", CollectionPeriod.class.getName(), CollectorActionExecutionTrackerImpl.class.getName()));
    }
}

