/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.vcenter;

import com.vmware.af.VmAfClient;
import com.vmware.ph.phservice.ciscommon.KeyStoreProvider;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextBuilder;
import com.vmware.ph.phservice.provider.vimcommon.VimContextProvider;
import java.net.URI;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfdVimContextProvider
implements VimContextProvider {
    private static final Log _log = LogFactory.getLog(AfdVimContextProvider.class);
    private final KeyStoreProvider _trustedKeyStoreProvider;
    private final KeyStoreProvider _solutionUserKeyStoreProvider;
    private final String _solutionUserEntryAlias;
    private VmAfClient _vmAfClient;

    public AfdVimContextProvider(KeyStoreProvider trustedKeyStoreProvider, KeyStoreProvider solutionUserKeyStoreProvider, String solutionUserEntryAlias) {
        this._trustedKeyStoreProvider = trustedKeyStoreProvider;
        this._solutionUserKeyStoreProvider = solutionUserKeyStoreProvider;
        this._solutionUserEntryAlias = solutionUserEntryAlias;
    }

    @Override
    public VimContext getVimContext() {
        VmAfClient vmAfClient = this.getVmAfClient();
        URI lookupServiceSdkUri = URI.create(vmAfClient.getLSLocation());
        String nodeId = vmAfClient.getLDU();
        KeyStore trustedKeyStore = this._trustedKeyStoreProvider.getKeyStore();
        KeyStore solutionUserKeyStore = this._solutionUserKeyStoreProvider.getKeyStore();
        VimContext vimContext = VimContextBuilder.forVim(lookupServiceSdkUri, trustedKeyStore).withVcNodeId(nodeId).withSsoSolutionUser(solutionUserKeyStore, this._solutionUserEntryAlias, null).build();
        if (vimContext.getVcInstanceUuid() == null) {
            _log.info((Object)"Did not manage to build valid VimContext object. This most probably is caused, because this code runs on PSC node. ");
            return null;
        }
        return vimContext;
    }

    private synchronized VmAfClient getVmAfClient() {
        if (this._vmAfClient == null) {
            this._vmAfClient = new VmAfClient("localhost");
        }
        return this._vmAfClient;
    }
}

