/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.vcenter;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.common.SafeDataProvidersConnectionWrapper;
import com.vmware.ph.phservice.provider.contentlibrary.ContentLibraryDataProvidersConnection;
import com.vmware.ph.phservice.provider.esx.EsxDataProvidersConnectionImpl;
import com.vmware.ph.phservice.provider.fcd.collector.FcdDataProvidersConnectionImpl;
import com.vmware.ph.phservice.provider.license.LicenseDataProvidersConnection;
import com.vmware.ph.phservice.provider.spbm.SpbmDataProvidersConnectionImpl;
import com.vmware.ph.phservice.provider.system.monitor.SystemDataProvidersConnection;
import com.vmware.ph.phservice.provider.vcenter.VcVimDataProvidersConnectionImpl;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextVcClientProviderImpl;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcenterTelemetryDataProvidersConnection
implements DataProvidersConnection {
    private static final Log _log = LogFactory.getLog(VcenterTelemetryDataProvidersConnection.class);
    private final VcClientProvider _readOnlyVcClientProvider;
    private final VcClientProvider _nonReadOnlyVcClientProvider;
    private final List<DataProvidersConnection> _dataProvidersConnectionList;

    public VcenterTelemetryDataProvidersConnection(VimContext readOnlyVimContext, VimContext nonReadOnlyVimContext) {
        this(readOnlyVimContext, nonReadOnlyVimContext, new DefaultVcClientProviderFactory(), new DefaultVcenterDataProvidersConnectionFactory());
    }

    VcenterTelemetryDataProvidersConnection(VimContext readOnlyVimContext, VimContext nonReadOnlyVimContext, VcClientProviderFactory vcClientProviderFactory, VcenterDataProvidersConnectionFactory dataProvidersFactory) {
        this._readOnlyVcClientProvider = vcClientProviderFactory.createVcClientProvider(readOnlyVimContext);
        this._nonReadOnlyVcClientProvider = vcClientProviderFactory.createVcClientProvider(nonReadOnlyVimContext);
        this._dataProvidersConnectionList = Collections.unmodifiableList(dataProvidersFactory.getDataProvidersConnectionList(readOnlyVimContext, this._readOnlyVcClientProvider, nonReadOnlyVimContext, this._nonReadOnlyVcClientProvider));
    }

    @Override
    public List<DataProvider> getDataProviders() throws Exception {
        LinkedList<DataProvider> dpList = new LinkedList<DataProvider>();
        for (DataProvidersConnection dpc : this._dataProvidersConnectionList) {
            dpList.addAll(dpc.getDataProviders());
        }
        return dpList;
    }

    @Override
    public void close() {
        ArrayList<AutoCloseable> toClose = new ArrayList<AutoCloseable>();
        for (DataProvidersConnection dpc : this._dataProvidersConnectionList) {
            toClose.add(dpc);
        }
        toClose.add(this._nonReadOnlyVcClientProvider);
        toClose.add(this._readOnlyVcClientProvider);
        boolean gotException = false;
        for (AutoCloseable closeable : toClose) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                gotException = true;
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)String.format("An exception occurred while trying to close resource of type %s. This may lead to not fully released resources. Next telemetry collection should not be impacted.", closeable.getClass().getCanonicalName()), (Throwable)e);
            }
        }
        if (gotException) {
            throw new RuntimeException("Not all closeable objects were successfully closed. This may lead to not fully released resources, but the next telemetry collection should not be impacted. Debug level logs contain more details about not properly closed data provider connections.");
        }
    }

    public VcClientProvider getReadOnlyVcClientProvider() {
        return this._readOnlyVcClientProvider;
    }

    static class DefaultVcenterDataProvidersConnectionFactory
    implements VcenterDataProvidersConnectionFactory {
        DefaultVcenterDataProvidersConnectionFactory() {
        }

        @Override
        public List<DataProvidersConnection> getDataProvidersConnectionList(VimContext readOnlyVimContext, VcClientProvider readOnlyVcClientProvider, VimContext nonReadOnlyVimContext, VcClientProvider nonReadOnlyVcClientProvider) {
            ArrayList<DataProvidersConnection> dpList = new ArrayList<DataProvidersConnection>();
            EsxDataProvidersConnectionImpl esxDpc = new EsxDataProvidersConnectionImpl(nonReadOnlyVimContext, nonReadOnlyVcClientProvider);
            dpList.add(esxDpc);
            VcVimDataProvidersConnectionImpl vcVimDpc = new VcVimDataProvidersConnectionImpl(readOnlyVimContext, readOnlyVcClientProvider);
            dpList.add(vcVimDpc);
            LicenseDataProvidersConnection licenseDpc = new LicenseDataProvidersConnection(readOnlyVimContext);
            dpList.add(licenseDpc);
            ContentLibraryDataProvidersConnection contentLibraryDpc = new ContentLibraryDataProvidersConnection(readOnlyVimContext);
            dpList.add(contentLibraryDpc);
            SystemDataProvidersConnection systemDpc = new SystemDataProvidersConnection(readOnlyVimContext);
            dpList.add(systemDpc);
            SpbmDataProvidersConnectionImpl spbmDpc = new SpbmDataProvidersConnectionImpl(nonReadOnlyVimContext, nonReadOnlyVcClientProvider);
            dpList.add(spbmDpc);
            FcdDataProvidersConnectionImpl fcdDpc = new FcdDataProvidersConnectionImpl(nonReadOnlyVimContext, nonReadOnlyVcClientProvider);
            dpList.add(fcdDpc);
            List<DataProvidersConnection> wrappedDpList = DefaultVcenterDataProvidersConnectionFactory.wrapDataProvidersConnectionsSafe(dpList);
            return wrappedDpList;
        }

        private static List<DataProvidersConnection> wrapDataProvidersConnectionsSafe(List<DataProvidersConnection> dataProviderConnections) {
            ArrayList<DataProvidersConnection> wrappedDataProvidersConnections = new ArrayList<DataProvidersConnection>(dataProviderConnections.size());
            for (DataProvidersConnection dataProvidersConnection : dataProviderConnections) {
                SafeDataProvidersConnectionWrapper wrappedDataProvidersConnection = new SafeDataProvidersConnectionWrapper(dataProvidersConnection);
                wrappedDataProvidersConnections.add(wrappedDataProvidersConnection);
            }
            return wrappedDataProvidersConnections;
        }
    }

    static class DefaultVcClientProviderFactory
    implements VcClientProviderFactory {
        DefaultVcClientProviderFactory() {
        }

        @Override
        public VcClientProvider createVcClientProvider(VimContext vimContext) {
            return new VimContextVcClientProviderImpl(vimContext);
        }
    }

    static interface VcClientProviderFactory {
        public VcClientProvider createVcClientProvider(VimContext var1);
    }

    static interface VcenterDataProvidersConnectionFactory {
        public List<DataProvidersConnection> getDataProvidersConnectionList(VimContext var1, VcClientProvider var2, VimContext var3, VcClientProvider var4);
    }
}

