/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.vcenter;

import com.vmware.ph.phservice.ciscommon.KeyStoreProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VecsKeyStoreProvider
implements KeyStoreProvider {
    private static final Log _log = LogFactory.getLog(VecsKeyStoreProvider.class);
    private static final String VECS_LOAD_PARAMETER_CLASSNAME = "com.vmware.provider.VecsLoadStoreParameter";
    private final String _storeName;

    public VecsKeyStoreProvider(String storeName) {
        this._storeName = storeName;
    }

    @Override
    public KeyStore getKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance("VKS");
            KeyStore.LoadStoreParameter loadParam = (KeyStore.LoadStoreParameter)Class.forName(VECS_LOAD_PARAMETER_CLASSNAME).getConstructor(String.class).newInstance(this._storeName);
            keyStore.load(loadParam);
            return keyStore;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            _log.warn((Object)"Did not manage to load a VECS keystore. This might lead to unsuccessful HTTPS connections and not properly authenticated API calls.");
            return null;
        }
    }
}

