/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cdf;

import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemManifestContentProvider
implements ManifestContentProvider {
    private static final Log _log = LogFactory.getLog(FileSystemManifestContentProvider.class);
    private final String _manifestPathName;

    public FileSystemManifestContentProvider(String manifestFilePathName) {
        this._manifestPathName = manifestFilePathName;
    }

    @Override
    public boolean isEnabled() {
        return this._manifestPathName != null && this.getManifestFile().isFile();
    }

    @Override
    public String getManifestContent(String collectorId, String collectorInstanceId) throws ManifestContentProvider.ManifestException {
        if (!this.isEnabled()) {
            throw new ManifestContentProvider.ManifestException(FileSystemManifestContentProvider.class.getName() + " is not enabled either because the manifest filename (" + this._manifestPathName + ") does not represent an existing filename.");
        }
        try {
            return this.getManifestContentFromFile(this.getManifestFile());
        }
        catch (IOException e) {
            throw new ManifestContentProvider.ManifestException("An IOException occurred while trying to read local file system manifest.", e);
        }
    }

    private String getManifestContentFromFile(File mfFile) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading manifest from file " + mfFile.getAbsolutePath()));
        }
        return FileUtils.readFileToString((File)this.getManifestFile());
    }

    File getManifestFile() {
        return new File(this._manifestPathName);
    }
}

