/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cdf;

import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.RdfCdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.client.api.commondataformat20.types.JsonLd;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemPayloadUploader
implements PayloadUploader {
    private static final Log _log = LogFactory.getLog(FileSystemPayloadUploader.class);
    private final String _outputDirectoryPathName;
    private final ExecutorService _executorService;

    public FileSystemPayloadUploader(String outputDirectoryPathName, ExecutorService executorService) {
        this._outputDirectoryPathName = outputDirectoryPathName;
        this._executorService = executorService;
    }

    @Override
    public boolean isEnabled() {
        return StringUtils.isNotBlank((String)this._outputDirectoryPathName);
    }

    @Override
    public Future<?> uploadPayload(final Payload20 payload, final PayloadEnvelope envelope, final String uploadId) {
        return this._executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws PayloadUploader.PayloadUploadException {
                FileSystemPayloadUploader.this.uploadPayloadBlocking(payload, envelope, uploadId);
                return null;
            }
        });
    }

    @Override
    public Future<?> uploadFile(String collectorId, String instanceId, String uploadId, final File fileToUpload) {
        return this._executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws PayloadUploader.PayloadUploadException {
                if (fileToUpload == null) {
                    _log.debug((Object)"A null File cannot be uploaded.");
                } else {
                    FileSystemPayloadUploader.this.uploadFileBlocking(fileToUpload);
                }
                return null;
            }
        });
    }

    private void uploadPayloadBlocking(Payload20 payload, PayloadEnvelope envelope, String uploadId) throws PayloadUploader.PayloadUploadException {
        if (!this.isEnabled()) {
            throw new PayloadUploader.PayloadUploadException(FileSystemPayloadUploader.class + " is not configured properly, it is not able to process specified payload.");
        }
        try {
            File outputDirectory = this.createOutputDirectory();
            int fileCount = outputDirectory.list().length;
            File filename = new File(outputDirectory, String.format("payload%04d.cdf", fileCount));
            try (FileOutputStream fileStream = new FileOutputStream(filename);
                 RdfCdfSequenceSerializer serializer = CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer((OutputStream)fileStream);){
                for (Resource res : payload.getResources()) {
                    serializer.write((CdfAble)res);
                }
                for (FreeFormData ffd : payload.getFreeforms()) {
                    serializer.write((CdfAble)ffd);
                }
            }
            List<JsonLd> jsons = payload.getJsons();
            for (JsonLd cdf : jsons) {
                filename = new File(outputDirectory, String.format("payload%04d.json", ++fileCount));
                PrintWriter out = new PrintWriter(filename, StandardCharsets.UTF_8.name());
                Throwable throwable = null;
                try {
                    out.println(cdf.asPrettyPrintedJson());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new PayloadUploader.PayloadUploadException("An exception occurred while trying to save payload on the local file system.", e);
        }
    }

    private void uploadFileBlocking(File fileToUpload) throws PayloadUploader.PayloadUploadException {
        if (!this.isEnabled()) {
            throw new PayloadUploader.PayloadUploadException(FileSystemPayloadUploader.class + " is not configured properly, it is not able to process specified payload.");
        }
        try {
            File outputDirectory = this.createOutputDirectory();
            FileUtils.copyFileToDirectory((File)fileToUpload, (File)outputDirectory);
        }
        catch (IOException e) {
            throw new PayloadUploader.PayloadUploadException("An exception occurred while trying to save upload file on the local file system.", e);
        }
    }

    private File createOutputDirectory() throws IOException {
        File outputDirectory = new File(this._outputDirectoryPathName);
        FileUtils.forceMkdir((File)outputDirectory);
        return outputDirectory;
    }
}

