/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cdf.jsonld20;

import org.json.JSONObject;

public class JSONObjectUtil {
    static JSONObject getOrCreateHolder(JSONObject root, String path, char separator) {
        return JSONObjectUtil.getOrCreateHolderInternal(root, path, 0, separator);
    }

    static JSONObject getOrCreateHolderInternal(JSONObject currentRoot, String fullPath, int propertyIndex, char separator) {
        boolean isLastProperty;
        boolean bl = isLastProperty = JSONObjectUtil.getPropertyCount(fullPath, separator) - 1 == propertyIndex;
        if (!isLastProperty) {
            JSONObject deepestHolder;
            String currentProperty = JSONObjectUtil.getProperty(propertyIndex, fullPath, separator);
            Object o = currentRoot.opt(currentProperty);
            if (o instanceof JSONObject) {
                deepestHolder = JSONObjectUtil.getOrCreateHolderInternal((JSONObject)o, fullPath, propertyIndex + 1, separator);
            } else if (null == o || JSONObject.NULL.equals(o)) {
                JSONObject j = new JSONObject();
                currentRoot.put(currentProperty, (Object)j);
                deepestHolder = JSONObjectUtil.getOrCreateHolderInternal(j, fullPath, propertyIndex + 1, separator);
            } else {
                throw new IllegalArgumentException("I was traversing path " + fullPath + " and I was expecting either JSONObject or nothing(null) at '" + currentProperty + "' in JSON " + currentRoot.toString(2) + "\n but I've found " + o.getClass().getName() + " with value " + o);
            }
            return deepestHolder;
        }
        return currentRoot;
    }

    static int getPropertyCount(String propPath, char separator) {
        StringBuilder charSequence = new StringBuilder();
        charSequence.append(separator);
        int res = 1 + propPath.length() - propPath.replace(charSequence, "").length();
        return res;
    }

    static String getProperty(int idxProperty, String propPath, char separator) {
        int posAfterSeparator = 0;
        for (int i = 0; i < idxProperty; ++i) {
            if (0 != (posAfterSeparator = 1 + propPath.indexOf(separator, posAfterSeparator))) continue;
            return null;
        }
        int posNextSeparator = propPath.indexOf(separator, posAfterSeparator);
        if (-1 == posNextSeparator) {
            posNextSeparator = propPath.length();
        }
        String res = propPath.substring(posAfterSeparator, posNextSeparator);
        return res;
    }
}

