/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cdf.jsonld20;

import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.phservice.common.cdf.jsonld20.JSONObjectUtil;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlEnumType;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class VmodlToJsonLdSerializer {
    public static final String TYPE_ATTRIBUTE = "@type";
    public static final String ID_ATTRIBUTE = "@id";
    private static final String VALUE_ATTRIBUTE = "@value";
    private static final String DECLARED_TYPE_ATTRIBUTE = "pa__declared_type";
    private static final String DATETIME_TYPE_VAL = "datetime";
    private static final String DO_DYNAMIC_TYPE_PROP = "dynamicType";
    private static final String DO_DYNAMIC_PROPERTY_PROP = "dynamicProperty";
    private static final String VMODL_CORE_TYPE_PREFIX = "com.vmware.vim.binding.vmodl";
    private final VmodlTypeMap _vmodlTypeMap;
    private final boolean _useWsdlTypes;
    private final List<String> _vmodlPackages;
    private boolean _serializeCalendarAsObject = false;

    public VmodlToJsonLdSerializer(VmodlTypeMap vmodlTypeMap) {
        this(vmodlTypeMap, true, null);
    }

    public VmodlToJsonLdSerializer(VmodlTypeMap vmodlTypeMap, List<String> vmodlPackages) {
        this(vmodlTypeMap, false, vmodlPackages);
    }

    private VmodlToJsonLdSerializer(VmodlTypeMap vmodlTypeMap, boolean useWsdlTypes, List<String> vmodlPackages) {
        this._vmodlTypeMap = vmodlTypeMap;
        this._useWsdlTypes = useWsdlTypes;
        this._vmodlPackages = new ArrayList<String>();
        if (vmodlPackages != null) {
            this._vmodlPackages.addAll(vmodlPackages);
        }
        if (!this._vmodlPackages.contains(VMODL_CORE_TYPE_PREFIX)) {
            this._vmodlPackages.add(VMODL_CORE_TYPE_PREFIX);
        }
    }

    public void setSerializeCalendarAsObject(boolean serializeAsObject) {
        this._serializeCalendarAsObject = serializeAsObject;
    }

    public Object serialize(Object vmodlObject) {
        return this.serialize(vmodlObject, null);
    }

    public JSONObject serialize(ManagedObjectReference moRef, Map<String, Object> propertyPathsToValue, char pathSeparator) {
        JSONObject result = this.serializeManagedObject(moRef);
        this.serializeProperties(result, propertyPathsToValue, pathSeparator);
        return result;
    }

    public JSONObject serialize(String type, String id, Map<String, Object> propertyPathsToValue, char pathSeparator) {
        JSONObject result = new JSONObject();
        result.put(TYPE_ATTRIBUTE, (Object)type);
        result.put(ID_ATTRIBUTE, (Object)id);
        this.serializeProperties(result, propertyPathsToValue, pathSeparator);
        return result;
    }

    public Object serialize(Object vmodlObject, VmodlType declaredType) {
        if (vmodlObject == null) {
            return null;
        }
        if (vmodlObject.getClass().isArray()) {
            return this.serializeArray(vmodlObject, declaredType);
        }
        if (vmodlObject instanceof DataObject) {
            return this.serializeDataObject((DataObject)vmodlObject, declaredType);
        }
        if (vmodlObject instanceof ManagedObjectReference) {
            return this.serializeMoRef((ManagedObjectReference)vmodlObject);
        }
        if (vmodlObject instanceof ManagedObject) {
            return this.serializeManagedObject(((ManagedObject)vmodlObject)._getRef());
        }
        if (vmodlObject instanceof Calendar) {
            Calendar calendar = (Calendar)vmodlObject;
            if (this._serializeCalendarAsObject) {
                return this.serializeCalendarAsObject(calendar);
            }
            return calendar.getTimeInMillis();
        }
        return vmodlObject;
    }

    public Object deserialize(Object jsonObject) {
        return this.deserialize(jsonObject, null);
    }

    public Object deserialize(Object json, VmodlType declaredType) {
        if (json == null || json.equals(JSONObject.NULL)) {
            return null;
        }
        if (json instanceof JSONArray) {
            return this.deserializeArray((JSONArray)json, declaredType);
        }
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            String objectTypeName = jsonObject.getString(TYPE_ATTRIBUTE);
            if (DATETIME_TYPE_VAL.equals(objectTypeName)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(jsonObject.getLong(VALUE_ATTRIBUTE));
                return calendar;
            }
            VmodlType vmodlType = this.getVmodlType(objectTypeName);
            VmodlType.Kind vmodlTypeKind = vmodlType.getKind();
            if (vmodlTypeKind == VmodlType.Kind.DATA_OBJECT) {
                return this.deserializeDataObject(jsonObject, declaredType);
            }
            if (vmodlTypeKind == VmodlType.Kind.MOREF) {
                return this.deserializeMoRef(jsonObject);
            }
            if (vmodlTypeKind == VmodlType.Kind.MANAGED_OBJECT) {
                return this.deserializeManagedObject(jsonObject);
            }
        }
        if (declaredType != null) {
            if (declaredType.getKind() == VmodlType.Kind.ENUM) {
                return ((VmodlEnumType)declaredType).getEnum(json.toString());
            }
            if (declaredType.getKind() == VmodlType.Kind.DATETIME) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis((Long)json);
                return calendar;
            }
        }
        return json;
    }

    private JSONArray serializeArray(Object vmodlObject, VmodlType declaredType) {
        assert (vmodlObject.getClass().isArray());
        Object[] vmodlArray = VmodlToJsonLdSerializer.convertObjectToObjectArray(vmodlObject);
        VmodlType arrElementType = null;
        if (declaredType != null) {
            VmodlArrayType arrType = (VmodlArrayType)declaredType;
            arrElementType = arrType.getComponentType();
        }
        JSONArray jsonArray = new JSONArray();
        for (Object vmodlObjectInArray : vmodlArray) {
            Object serializedObject = this.serialize(vmodlObjectInArray, arrElementType);
            jsonArray.put(serializedObject);
        }
        return jsonArray;
    }

    private JSONObject serializeDataObject(DataObject dataObject, VmodlType declaredType) {
        ComplexTypeField[] properties;
        String declaredInParentAs;
        Class declaredClass;
        JSONObject j = new JSONObject();
        Class<?> actualClass = dataObject.getClass();
        VmodlType vmodlType = this._vmodlTypeMap.getVmodlType(actualClass);
        if (null != declaredType && !(declaredClass = declaredType.getTypeClass()).isAssignableFrom(actualClass)) {
            throw new Bug("I was expecting " + actualClass + "" + " to be equal to, or child of " + declaredClass);
        }
        String objectTypeName = this.getObjectTypeName(vmodlType);
        j.put(TYPE_ATTRIBUTE, (Object)objectTypeName);
        if (null != declaredType && !objectTypeName.equals(declaredInParentAs = this.getObjectTypeName(declaredType))) {
            j.put(DECLARED_TYPE_ATTRIBUTE, (Object)declaredInParentAs);
        }
        for (ComplexTypeField property : properties = ((DataObjectType)vmodlType).getProperties()) {
            if (DO_DYNAMIC_TYPE_PROP.equals(property.getName()) || DO_DYNAMIC_PROPERTY_PROP.equals(property.getName())) continue;
            String fieldName = property.getName();
            Object fieldValue = property.get((Object)dataObject);
            VmodlType fieldType = property.getType();
            Object serializedValue = null;
            if (!this.handleNull(j, fieldName, fieldValue)) {
                serializedValue = this.serialize(fieldValue, fieldType);
            }
            j.put(fieldName, serializedValue);
        }
        return j;
    }

    private JSONObject serializeMoRef(ManagedObjectReference moRef) {
        JSONObject jAttribute = new JSONObject();
        VmodlType vmodlType = this._vmodlTypeMap.getVmodlType(ManagedObjectReference.class);
        String typeName = this.getObjectTypeName(vmodlType);
        jAttribute.put(TYPE_ATTRIBUTE, (Object)typeName);
        String id = this.getIdFromMoRef(moRef);
        jAttribute.put(ID_ATTRIBUTE, (Object)id);
        return jAttribute;
    }

    private JSONObject serializeManagedObject(ManagedObjectReference moRef) {
        JSONObject jAttribute = new JSONObject();
        VmodlType vmodlType = this._vmodlTypeMap.getVmodlType(moRef.getType());
        String typeName = this.getObjectTypeName(vmodlType);
        jAttribute.put(TYPE_ATTRIBUTE, (Object)typeName);
        String id = this.getIdFromMoRef(moRef);
        jAttribute.put(ID_ATTRIBUTE, (Object)id);
        return jAttribute;
    }

    private JSONObject serializeCalendarAsObject(Calendar calendar) {
        JSONObject result = new JSONObject();
        result.put(TYPE_ATTRIBUTE, (Object)DATETIME_TYPE_VAL);
        result.put(VALUE_ATTRIBUTE, calendar.getTimeInMillis());
        return result;
    }

    Object deserializeArray(JSONArray jsonArray, VmodlType declaredType) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return null;
        }
        ArrayList<Object> deserializedObjects = new ArrayList<Object>();
        Iterator objects = jsonArray.iterator();
        while (objects.hasNext()) {
            deserializedObjects.add(this.deserialize(objects.next()));
        }
        Object firstObject = jsonArray.get(0);
        Class resultClass = null;
        boolean isPrimitive = false;
        if (firstObject instanceof JSONObject) {
            JSONObject firstJsonObject = (JSONObject)firstObject;
            String objectTypeName = firstJsonObject.getString(TYPE_ATTRIBUTE);
            if (declaredType != null && declaredType instanceof VmodlArrayType) {
                VmodlArrayType arrType = (VmodlArrayType)declaredType;
                VmodlType arrElementType = arrType.getComponentType();
                resultClass = arrElementType.getTypeClass();
            } else {
                resultClass = this.getVmodlType(objectTypeName).getTypeClass();
            }
        } else {
            resultClass = firstObject.getClass();
            isPrimitive = true;
        }
        Object arrayObjectToSet = VmodlToJsonLdSerializer.convertObjectArrayToClazzArray(deserializedObjects.toArray(), resultClass);
        if (isPrimitive) {
            arrayObjectToSet = VmodlToJsonLdSerializer.convertBoxedArrayToPrimitivesArray(arrayObjectToSet);
        }
        return arrayObjectToSet;
    }

    DataObject deserializeDataObject(JSONObject jsonObject, VmodlType declaredType) {
        ComplexTypeField[] properties;
        String objectTypeName = jsonObject.getString(TYPE_ATTRIBUTE);
        VmodlType vmodlType = this.getVmodlType(objectTypeName);
        DataObject dataObject = (DataObject)((DataObjectType)vmodlType).newInstance();
        for (ComplexTypeField property : properties = ((DataObjectType)vmodlType).getProperties()) {
            String fieldName = property.getName();
            if (DO_DYNAMIC_TYPE_PROP.equals(property.getName()) || DO_DYNAMIC_PROPERTY_PROP.equals(property.getName()) || !jsonObject.has(fieldName)) continue;
            Object fieldValue = jsonObject.get(fieldName);
            Object deserializedValue = this.deserialize(fieldValue, property.getType());
            if (property.getType().getKind() == VmodlType.Kind.LONG) {
                property.set((Object)dataObject, (Object)Long.valueOf(deserializedValue.toString()));
                continue;
            }
            if (property.getType().getKind() == VmodlType.Kind.DOUBLE) {
                property.set((Object)dataObject, (Object)Double.valueOf(deserializedValue.toString()));
                continue;
            }
            property.set((Object)dataObject, deserializedValue);
        }
        return dataObject;
    }

    ManagedObjectReference deserializeMoRef(JSONObject jsonObject) {
        String id = jsonObject.getString(ID_ATTRIBUTE);
        String[] moRefComponents = VmodlToJsonLdSerializer.getMoRefComponentsFromId(id);
        String objectTypeName = moRefComponents[0];
        VmodlType vmodlType = this.getVmodlType(objectTypeName);
        String wsdlTypeName = vmodlType.getWsdlName();
        ManagedObjectReference moRef = new ManagedObjectReference(wsdlTypeName, moRefComponents[1], moRefComponents[2]);
        return moRef;
    }

    ManagedObjectReference deserializeManagedObject(JSONObject jsonObject) {
        return this.deserializeMoRef(jsonObject);
    }

    void serializeProperties(JSONObject rootObject, Map<String, Object> propertyPathsToValue, char pathSeparator) {
        for (Map.Entry<String, Object> entry : propertyPathsToValue.entrySet()) {
            String propertyPath = entry.getKey();
            Object propertyValue = entry.getValue();
            JSONObject holder = JSONObjectUtil.getOrCreateHolder(rootObject, propertyPath, pathSeparator);
            int lastIndexOf = propertyPath.lastIndexOf(pathSeparator);
            String propertyName = lastIndexOf == -1 ? propertyPath : propertyPath.substring(lastIndexOf + 1);
            Object serializedPropertyValue = this.serialize(propertyValue);
            holder.put(propertyName, serializedPropertyValue);
        }
    }

    private boolean handleNull(JSONObject j, String attrName, Object attrValue) {
        if (null == attrValue) {
            j.put(attrName, JSONObject.NULL);
            return true;
        }
        return false;
    }

    static Object[] convertObjectToObjectArray(Object array) {
        Object[] arrO = new Object[]{};
        try {
            arrO = (Object[])array;
        }
        catch (ClassCastException e) {
            if (new short[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((short[])((short[])array));
            }
            if (new int[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((int[])((int[])array));
            }
            if (new long[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((long[])((long[])array));
            }
            if (new float[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((float[])((float[])array));
            }
            if (new double[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((double[])((double[])array));
            }
            if (new boolean[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((boolean[])((boolean[])array));
            }
            if (new byte[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((byte[])((byte[])array));
            }
            if (new char[0].getClass().equals(array.getClass())) {
                arrO = ArrayUtils.toObject((char[])((char[])array));
            }
            throw new Bug("ARRAY serialization for class " + array.getClass() + " is not implemented. " + "The following data will not be serialized (Is it an array?): " + array);
        }
        return arrO;
    }

    static Object convertBoxedArrayToPrimitivesArray(Object array) {
        Object arrO;
        if (new Short[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Short[])((Short[])array));
        } else if (new Integer[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Integer[])((Integer[])array));
        } else if (new Long[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Long[])((Long[])array));
        } else if (new Float[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Float[])((Float[])array));
        } else if (new Double[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Double[])((Double[])array));
        } else if (new Boolean[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Boolean[])((Boolean[])array));
        } else if (new Byte[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Byte[])((Byte[])array));
        } else if (new Character[0].getClass().equals(array.getClass())) {
            arrO = ArrayUtils.toPrimitive((Character[])((Character[])array));
        } else if (new String[0].getClass().equals(array.getClass())) {
            arrO = array;
        } else {
            throw new Bug("ARRAY deserialization for class " + array.getClass() + " is not implemented. " + "The following data will not be deserialized (Is it an array?): " + array);
        }
        return arrO;
    }

    private static Object convertObjectArrayToClazzArray(Object[] array, Class<?> clazz) {
        Object newArray = Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            Array.set(newArray, i, array[i]);
        }
        return newArray;
    }

    private String getObjectTypeName(VmodlType objectVmodlType) {
        if (this._useWsdlTypes) {
            return objectVmodlType.getWsdlName();
        }
        return this.getObjectTypeNameByPackageName(objectVmodlType);
    }

    private VmodlType getVmodlType(String objectTypeName) {
        VmodlType vmodlType = null;
        vmodlType = this._useWsdlTypes ? this._vmodlTypeMap.getVmodlType(objectTypeName) : this.getVmodlTypeByPackageName(objectTypeName);
        return vmodlType;
    }

    private String getObjectTypeNameByPackageName(VmodlType objectVmodlType) {
        String className = objectVmodlType.getTypeName().getName();
        for (String vmodlPackage : this._vmodlPackages) {
            if (!className.startsWith(vmodlPackage)) continue;
            String vmodlPackagePrefix = VmodlToJsonLdSerializer.getVmodlPackagePrefix(vmodlPackage);
            String rawClassName = className.substring(vmodlPackagePrefix.length() + 1);
            return rawClassName.replaceAll("\\$", ".");
        }
        return null;
    }

    private VmodlType getVmodlTypeByPackageName(String objectTypeName) {
        objectTypeName = VmodlToJsonLdSerializer.convertTypeNameToValidClassName(objectTypeName);
        for (String vmodlPackage : this._vmodlPackages) {
            String vmodlPackagePrefix;
            String vmodlRawPackage = vmodlPackage.substring((vmodlPackagePrefix = VmodlToJsonLdSerializer.getVmodlPackagePrefix(vmodlPackage)).length());
            if (vmodlRawPackage.startsWith(".")) {
                vmodlRawPackage = vmodlRawPackage.substring(1);
            }
            if (!objectTypeName.startsWith(vmodlRawPackage)) continue;
            String inputVmodlClassName = vmodlPackagePrefix + "." + objectTypeName;
            try {
                Class<?> vmodlTypeClass = Class.forName(inputVmodlClassName);
                VmodlType result = this._vmodlTypeMap.getVmodlType(vmodlTypeClass);
                if (result == null) continue;
                return result;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    static String getVmodlPackagePrefix(String vmodlPackage) {
        String vmodlPackagePrefix = vmodlPackage.replaceFirst("[.]binding.*", ".binding");
        return vmodlPackagePrefix;
    }

    static String convertTypeNameToValidClassName(String objectTypeName) {
        String[] objectTypeNameSegments = objectTypeName.split("\\.");
        StringBuilder objectTypeNameAsClassBuilder = new StringBuilder();
        boolean isClassNameFound = false;
        for (String segment : objectTypeNameSegments) {
            if (objectTypeNameAsClassBuilder.length() > 0) {
                if (isClassNameFound) {
                    objectTypeNameAsClassBuilder.append("$");
                } else {
                    objectTypeNameAsClassBuilder.append(".");
                }
            }
            objectTypeNameAsClassBuilder.append(segment);
            if (!Character.isUpperCase(segment.codePointAt(0))) continue;
            isClassNameFound = true;
        }
        return objectTypeNameAsClassBuilder.toString();
    }

    private String getIdFromMoRef(ManagedObjectReference moRef) {
        VmodlType vmodlType = this._vmodlTypeMap.getVmodlType(moRef.getType());
        String typeName = this.getObjectTypeName(vmodlType);
        String id = typeName + ":" + moRef.getValue() + ":" + moRef.getServerGuid();
        return id;
    }

    private static String[] getMoRefComponentsFromId(String id) {
        String[] segments = id.split(":");
        return segments;
    }
}

