/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log _log = LogFactory.getLog(FileUtil.class);

    public static Path[] listFiles(Path directory, FilenameFilter fileNameFilter) {
        File[] files = directory.toFile().listFiles(fileNameFilter);
        Path[] paths = new Path[]{};
        if (files != null) {
            paths = FileUtil.toPaths(files);
        }
        return paths;
    }

    public static Path[] toPaths(File[] files) {
        Path[] paths = new Path[files.length];
        int i = 0;
        for (File file : files) {
            paths[i] = file.toPath();
            ++i;
        }
        return paths;
    }

    public static boolean isFileModifiedAfterTimestamp(Path logFilePath, Date timestamp) {
        boolean isModified = false;
        if (timestamp == null) {
            isModified = true;
        } else if (logFilePath != null && logFilePath.toFile() != null && timestamp.getTime() < FileUtil.getLastModified(logFilePath)) {
            isModified = true;
        }
        return isModified;
    }

    public static List<String> readLinesSafe(File file) {
        try {
            return Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Could not read lines of file " + file), (Throwable)e);
            }
            return new LinkedList<String>();
        }
    }

    public static void writeLinesSafe(File file, List<String> contentLines) {
        block2: {
            try {
                Files.write(file.toPath(), contentLines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)("Could not write to file " + file), (Throwable)e);
            }
        }
    }

    public static long getLastModified(Path path) {
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            return lastModifiedTime.toMillis();
        }
        catch (Exception e) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Could obtain exact last modified time for " + path), (Throwable)e);
            }
            return path.toFile().lastModified();
        }
    }
}

