/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.client.api.exceptions.PhClientConnectionException;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import com.vmware.ph.phservice.common.ph.PhClientFactory;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class PhPayloadUploader
implements PayloadUploader {
    private final PhClientFactory _phClientFactory;
    private final ExecutorService _executorService;

    public PhPayloadUploader(PhClientFactory phClientFactory, ExecutorService executorService) {
        this._phClientFactory = phClientFactory;
        this._executorService = executorService;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Future<?> uploadPayload(final Payload20 payload, final PayloadEnvelope envelope, final String uploadId) {
        Future<Object> result = this._executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws PayloadUploader.PayloadUploadException, InterruptedException, ExecutionException {
                return PhPayloadUploader.this.uploadPayloadBlocking(payload, envelope, uploadId);
            }
        });
        return result;
    }

    @Override
    public Future<?> uploadFile(final String collectorId, final String instanceId, final String uploadId, final File fileToUpload) {
        Future<Object> task = this._executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws PayloadUploader.PayloadUploadException, InterruptedException, ExecutionException {
                return PhPayloadUploader.this.uploadFileBlocking(collectorId, instanceId, uploadId, fileToUpload);
            }
        });
        return task;
    }

    public Object uploadPayloadBlocking(Payload20 payload, PayloadEnvelope envelope, String uploadId) throws PayloadUploader.PayloadUploadException, InterruptedException, ExecutionException {
        Object result;
        try (PhClient phClient = this._phClientFactory.createPhClient(envelope.getCollector());){
            Future uploadTask = phClient.sendPayload((Payload)payload, envelope, uploadId);
            result = uploadTask.get();
        }
        catch (PhClientConnectionException e) {
            throw new PayloadUploader.PayloadUploadException((Exception)((Object)e));
        }
        return result;
    }

    private Object uploadFileBlocking(String collectorId, String instanceId, String uploadId, File fileToUpload) throws PayloadUploader.PayloadUploadException, InterruptedException, ExecutionException {
        try (PhClient phClient = this._phClientFactory.createPhClient(new Collector(collectorId, instanceId));){
            Object result;
            Future uploadTask = phClient.upload(collectorId, instanceId, uploadId, fileToUpload);
            Object v = result = uploadTask.get();
            return v;
        }
    }
}

