/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.common;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyUtil {
    private static final Log log = LogFactory.getLog(CopyUtil.class);

    public static void copyPublicFields(Object srcObject, Object destObject) {
        Field[] fields;
        Class<?> destType = destObject.getClass();
        for (Field field : fields = destType.getFields()) {
            try {
                Field srcField = srcObject.getClass().getField(field.getName());
                if (srcField == null || !srcField.getType().isAssignableFrom(field.getType())) continue;
                field.set(destObject, srcField.get(srcObject));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Cannot copy field with name " + field.getName() + " because " + e.getMessage()));
            }
        }
    }
}

