/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.common;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.common.SafeDataProviderWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeDataProvidersConnectionWrapper
implements DataProvidersConnection {
    private static final Log _log = LogFactory.getLog(SafeDataProvidersConnectionWrapper.class);
    private final DataProvidersConnection _dataProvidersConnection;

    public SafeDataProvidersConnectionWrapper(DataProvidersConnection dataProvidersConnection) {
        this._dataProvidersConnection = dataProvidersConnection;
    }

    @Override
    public List<DataProvider> getDataProviders() {
        try {
            List<DataProvider> dataProviders = this._dataProvidersConnection.getDataProviders();
            ArrayList<DataProvider> wrappedDataProviders = new ArrayList<DataProvider>(dataProviders.size());
            for (DataProvider dataProvider : dataProviders) {
                wrappedDataProviders.add(new SafeDataProviderWrapper(dataProvider));
            }
            return wrappedDataProviders;
        }
        catch (Throwable e) {
            _log.error((Object)("Error while getting the data providers list from: " + this._dataProvidersConnection.getClass().getName()), e);
            return Collections.emptyList();
        }
    }

    @Override
    public void close() {
        try {
            this._dataProvidersConnection.close();
        }
        catch (Throwable e) {
            _log.error((Object)String.format("Error while closing data provider connection [%s]. This may lead to memory leaks.", this._dataProvidersConnection.getClass().getName()), e);
        }
    }
}

