/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.esx.data.EsxTelemetryDataProvider;
import com.vmware.ph.phservice.provider.esx.files.EsxCfgInfoDataProvider;
import com.vmware.ph.phservice.provider.esx.files.util.ssl.KeyStoreBasedTrustStrategy;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimDataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public final class EsxDataProvidersConnectionImpl
extends VimDataProvidersConnection {
    private static final int CONNECTION_TIMEOUT_MILLIS = 60000;
    private static final int SOCKET_TIMEOUT_MILLIS = 120000;
    private static final Log _log = LogFactory.getLog(EsxDataProvidersConnectionImpl.class);
    private final Object _lock = new Object();
    private CloseableHttpClient _httpClient;

    public EsxDataProvidersConnectionImpl(VimContext vimContext) {
        super(vimContext);
    }

    public EsxDataProvidersConnectionImpl(VimContext vimContext, VcClientProvider vcClientProvider) {
        super(vimContext, vcClientProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataProvider> getDataProviders() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            if (this._httpClient == null) {
                this._httpClient = EsxDataProvidersConnectionImpl.createHttpClient(this._vimContext);
            }
        }
        VcClient vcClient = this.getVcClient();
        EsxCfgInfoDataProvider esxCfgInfoDataProvider = new EsxCfgInfoDataProvider(vcClient, (HttpClient)this._httpClient);
        EsxTelemetryDataProvider esxTelemetryDataProvider = new EsxTelemetryDataProvider(vcClient);
        return Arrays.asList(esxCfgInfoDataProvider, esxTelemetryDataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this._lock;
        synchronized (object) {
            block6: {
                if (this._httpClient != null) {
                    try {
                        this._httpClient.close();
                    }
                    catch (IOException e) {
                        if (!_log.isWarnEnabled()) break block6;
                        _log.warn((Object)"Unable to close HTTP client. There is a risk of memory leaks.");
                    }
                }
            }
        }
    }

    private static CloseableHttpClient createHttpClient(VimContext vimContext) {
        KeyStoreBasedTrustStrategy trustStrategy = new KeyStoreBasedTrustStrategy(vimContext.getVimTrustedStore());
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((TrustStrategy)trustStrategy).build();
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(60000).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(sslContext).setDefaultRequestConfig(requestConfig).build();
            return httpClient;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create HTTP client using the VIM trust store.", e);
        }
    }
}

