/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.data;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.common.QueryUtil;
import com.vmware.ph.phservice.provider.esx.data.EsxTelemetryInfoStream;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.HostReader;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.InternalConfigManager;
import com.vmware.vim.binding.vim.host.TelemetryManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EsxTelemetryDataProvider
implements DataProvider {
    static final String RESOURCE_MODEL_TYPE = "HostTelemetryManager";
    static final String TELEMETRY_DATA_PROPERTY = "telemetryData";
    static final String TELEMETRY_WHITE_LIST_PROPERTY = "whiteList";
    static final String TELEMETRY_BLACK_LIST_PROPERTY = "blackList";
    private static final Log _log = LogFactory.getLog(EsxTelemetryDataProvider.class);
    private final VcClient _vcClient;
    private final QuerySchema _querySchema;
    private final HostReader _hostReader;

    public EsxTelemetryDataProvider(VcClient vcClient) {
        this(vcClient, new HostReader(vcClient));
    }

    EsxTelemetryDataProvider(VcClient vcClient, HostReader hostReader) {
        this._vcClient = vcClient;
        this._hostReader = hostReader;
        this._querySchema = EsxTelemetryDataProvider.createQuerySchema();
    }

    public QuerySchema getSchema() {
        return this._querySchema;
    }

    public ResultSet executeQuery(Query query) {
        List queryProperties = query.getProperties();
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)queryProperties);
        List<String> whiteList = QueryUtil.getFilterPropertyComparableValues(query, TELEMETRY_WHITE_LIST_PROPERTY);
        List<String> blackList = QueryUtil.getFilterPropertyComparableValues(query, TELEMETRY_BLACK_LIST_PROPERTY);
        List<ManagedObjectReference> hostMoRefs = this._hostReader.getHostMoRefs();
        if (QueryUtil.selectsActualProperty(query, TELEMETRY_DATA_PROPERTY)) {
            for (ManagedObjectReference hostMoRef : hostMoRefs) {
                HostSystem host = (HostSystem)this._vcClient.createMo(hostMoRef);
                String hostSystemInfoUuid = host.getHardware().getSystemInfo().getUuid();
                TelemetryManager.TelemetryInfo telemetryInfo = this.readTelemetryInfo(hostMoRef, whiteList, blackList);
                if (telemetryInfo != null) {
                    URI modelKey = VimDataProviderUtil.createModelKey(TelemetryManager.class, hostSystemInfoUuid);
                    List<Object> propertyValues = EsxTelemetryDataProvider.buildPropertyValues(queryProperties, modelKey, telemetryInfo, whiteList, blackList);
                    resultSetBuilder.item((Object)modelKey, propertyValues);
                    continue;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No telemetry info available for host " + hostMoRef));
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)"No ESX telemetry data has been requested. Returning an empty result.");
        }
        return resultSetBuilder.build();
    }

    private TelemetryManager.TelemetryInfo readTelemetryInfo(ManagedObjectReference hostMoRef, List<String> whiteList, List<String> blackList) {
        TelemetryManager.TelemetryInfo telemetryInfo = null;
        TelemetryManager telemetryManager = EsxTelemetryDataProvider.createHostTelemetryManager(this._vcClient, hostMoRef);
        if (telemetryManager != null) {
            telemetryInfo = new TelemetryManager.TelemetryInfo();
            TelemetryManager.TelemetryFilterSpec filterSpec = this.createTelemetryFilterSpec(whiteList, blackList);
            EsxTelemetryInfoStream telemetryItemsStream = new EsxTelemetryInfoStream(telemetryManager, filterSpec);
            List<KeyAnyValue> telemetryData = PageUtil.pageItems(telemetryItemsStream, 0, -1);
            List<KeyAnyValue> filteredTelemetryData = EsxTelemetryDataProvider.filterInvalidEntries(telemetryData);
            telemetryInfo.setData(filteredTelemetryData.toArray(new KeyAnyValue[filteredTelemetryData.size()]));
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Telemetry not available for host " + hostMoRef));
        }
        return telemetryInfo;
    }

    private static List<KeyAnyValue> filterInvalidEntries(List<KeyAnyValue> telemetryData) {
        ArrayList<KeyAnyValue> filteredTelemetryData = new ArrayList<KeyAnyValue>();
        for (KeyAnyValue entry : telemetryData) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            filteredTelemetryData.add(entry);
        }
        return filteredTelemetryData;
    }

    private TelemetryManager.TelemetryFilterSpec createTelemetryFilterSpec(List<String> whiteList, List<String> blackList) {
        TelemetryManager.TelemetryFilterSpec filterSpec = new TelemetryManager.TelemetryFilterSpec();
        filterSpec.setWhitelist(whiteList.toArray(new String[whiteList.size()]));
        filterSpec.setBlacklist(blackList.toArray(new String[blackList.size()]));
        return filterSpec;
    }

    private static TelemetryManager createHostTelemetryManager(VcClient vcClient, ManagedObjectReference hostMoRef) {
        HostSystem host = (HostSystem)vcClient.createMo(hostMoRef);
        InternalConfigManager internalConfigManager = host.retrieveInternalConfigManager();
        ManagedObjectReference telemetryManagerMoRef = internalConfigManager.getTelemetryManager();
        if (telemetryManagerMoRef != null) {
            return (TelemetryManager)vcClient.createMo(telemetryManagerMoRef);
        }
        return null;
    }

    private static QuerySchema createQuerySchema() {
        TreeMap<String, QuerySchema.PropertyInfo> propertiesInfo = new TreeMap<String, QuerySchema.PropertyInfo>();
        propertiesInfo.put(TELEMETRY_DATA_PROPERTY, QuerySchema.PropertyInfo.forNonFilterableProperty());
        propertiesInfo.put(TELEMETRY_WHITE_LIST_PROPERTY, QuerySchema.PropertyInfo.forNonFilterableProperty());
        propertiesInfo.put(TELEMETRY_BLACK_LIST_PROPERTY, QuerySchema.PropertyInfo.forNonFilterableProperty());
        QuerySchema.ModelInfo modelInfo = new QuerySchema.ModelInfo(propertiesInfo);
        TreeMap<String, QuerySchema.ModelInfo> models = new TreeMap<String, QuerySchema.ModelInfo>();
        models.put(RESOURCE_MODEL_TYPE, modelInfo);
        return QuerySchema.forModels(models);
    }

    private static List<Object> buildPropertyValues(List<String> queryProperties, URI modelKey, TelemetryManager.TelemetryInfo telemetryInfo, List<String> esxTelemetryWhiteList, List<String> esxTelemetryBlackList) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        propertyValues.add(modelKey);
        for (String property : queryProperties) {
            switch (QuerySchemaUtil.getActualPropertyName(property)) {
                case "telemetryData": {
                    propertyValues.add(telemetryInfo);
                    break;
                }
                case "whiteList": {
                    propertyValues.add(esxTelemetryWhiteList);
                    break;
                }
                case "blackList": {
                    propertyValues.add(esxTelemetryBlackList);
                }
            }
        }
        return propertyValues;
    }
}

