/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.ciscommon.ProductVersion;
import com.vmware.ph.phservice.provider.common.QueryUtil;
import com.vmware.ph.phservice.provider.esx.files.EsxCfgInfoReader;
import com.vmware.ph.phservice.provider.esx.files.util.EsxFileLayout;
import com.vmware.ph.phservice.provider.esx.files.util.JacksonSerializer;
import com.vmware.ph.phservice.provider.esx.files.util.StatsLogger;
import com.vmware.ph.phservice.provider.esx.files.util.compress.Tar;
import com.vmware.ph.phservice.provider.esx.files.util.compress.Zip;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.HostReader;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;

public final class EsxCfgInfoDataProvider
implements DataProvider {
    static final String RESOURCE_MODEL_TYPE = "VSphere";
    static final String VSPHERE_BUNDLE_PROPERTY = "esxCfgInfoWithVcData";
    static final String ESX_CFG_INFO_WHITE_LIST_PROPERTY = "esxCfgInfoWhiteList";
    private static final ProductVersion MIN_SUPPORTED_HOST_VERSION = new ProductVersion("6.6.2");
    private static final Log _log = LogFactory.getLog(EsxCfgInfoDataProvider.class);
    private final VcClient _vcClient;
    private final QuerySchema _querySchema;
    private final EsxCfgInfoReader _esxCfgInfoReader;
    private final HostReader _hostReader;
    private final JacksonSerializer _jacksonSerializer;
    private final EsxFileLayoutFactory _esxFileLayoutFactory;

    public EsxCfgInfoDataProvider(VcClient vcClient, HttpClient httpClient) {
        this._vcClient = Objects.requireNonNull(vcClient);
        this._querySchema = EsxCfgInfoDataProvider.createQuerySchema();
        this._hostReader = new HostReader(this._vcClient);
        this._esxCfgInfoReader = new EsxCfgInfoReader(this._vcClient, httpClient);
        this._jacksonSerializer = new JacksonSerializer();
        this._esxFileLayoutFactory = new EsxFileLayoutFactory();
    }

    EsxCfgInfoDataProvider(VcClient vcClient, QuerySchema querySchema, EsxCfgInfoReader esxCfgInfoReader, HostReader hostReader, JacksonSerializer jacksonSerializer, EsxFileLayoutFactory esxFileLayoutFactory) {
        this._vcClient = vcClient;
        this._querySchema = querySchema;
        this._esxCfgInfoReader = esxCfgInfoReader;
        this._hostReader = hostReader;
        this._jacksonSerializer = jacksonSerializer;
        this._esxFileLayoutFactory = esxFileLayoutFactory;
    }

    public QuerySchema getSchema() {
        return this._querySchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(Query query) {
        List queryProperties = query.getProperties();
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)queryProperties);
        List<String> esxCfgInfoFilters = QueryUtil.getFilterPropertyComparableValues(query, ESX_CFG_INFO_WHITE_LIST_PROPERTY);
        if (esxCfgInfoFilters.isEmpty()) {
            throw new IllegalArgumentException("No white-list filters provided for ESX cfg info. Cannot proceed with data collection.");
        }
        EsxFileLayout fileLayout = null;
        try {
            fileLayout = this._esxFileLayoutFactory.createEsxFileLayout();
            this.collectEsxCfgInfo(queryProperties, esxCfgInfoFilters, fileLayout, resultSetBuilder);
        }
        catch (IOException e) {
            _log.debug((Object)"Could not create ESX collection folder. No ESX CFG info collected.");
        }
        finally {
            if (fileLayout != null) {
                fileLayout.cleanUp();
            }
        }
        return resultSetBuilder.build();
    }

    private static QuerySchema createQuerySchema() {
        TreeMap<String, QuerySchema.ModelInfo> models = new TreeMap<String, QuerySchema.ModelInfo>(){
            {
                TreeMap<String, QuerySchema.PropertyInfo> propertiesInfo = new TreeMap<String, QuerySchema.PropertyInfo>();
                propertiesInfo.put(EsxCfgInfoDataProvider.VSPHERE_BUNDLE_PROPERTY, QuerySchema.PropertyInfo.forNonFilterableProperty());
                propertiesInfo.put(EsxCfgInfoDataProvider.ESX_CFG_INFO_WHITE_LIST_PROPERTY, QuerySchema.PropertyInfo.forNonFilterableProperty());
                QuerySchema.ModelInfo modelInfo = new QuerySchema.ModelInfo(propertiesInfo);
                this.put(EsxCfgInfoDataProvider.RESOURCE_MODEL_TYPE, modelInfo);
            }
        };
        return QuerySchema.forModels((Map)models);
    }

    private void collectEsxCfgInfo(List<String> queryProperties, List<String> esxCfgInfoFilters, EsxFileLayout fileLayout, ResultSet.Builder resultSetBuilder) {
        File collectionStatsFile = fileLayout.getPerformanceStatsFile();
        StatsLogger statsLogger = new StatsLogger(collectionStatsFile);
        List<ManagedObjectReference> hostMoRefs = this._hostReader.getHostMoRefs();
        this.collectVcAboutInfo(fileLayout, statsLogger);
        for (ManagedObjectReference hostMoRef : hostMoRefs) {
            this.collectHostData(hostMoRef, esxCfgInfoFilters, fileLayout, statsLogger);
        }
        File vSphereBundle = this.createVSphereBundle(fileLayout);
        if (vSphereBundle != null) {
            resultSetBuilder.item((Object)vSphereBundle, Collections.nCopies(queryProperties.size(), vSphereBundle).toArray());
        }
    }

    private void collectHostData(ManagedObjectReference hostMoRef, List<String> esxCfgInfoFilters, EsxFileLayout fileLayout, StatsLogger statsLogger) {
        String hostMoRefId = hostMoRef.getValue();
        ProductVersion hostVersion = this._hostReader.getHostVersion(hostMoRef);
        statsLogger.append("version-of-" + hostMoRefId + "\t" + hostVersion);
        String hostUuid = this._hostReader.getHostUuid(hostMoRef);
        statsLogger.append("uuid-of-" + hostMoRefId + "\t" + hostUuid);
        if (hostVersion != null && hostVersion.compareTo(MIN_SUPPORTED_HOST_VERSION) >= 0) {
            long startTime = System.currentTimeMillis();
            File esxCfgInfoFile = this._esxCfgInfoReader.getEsxCfgInfo(hostMoRef, esxCfgInfoFilters, fileLayout);
            long endTime = System.currentTimeMillis();
            statsLogger.append("retrieveTimeForEsxCfg_" + hostMoRefId + "\t" + (endTime - startTime));
            this.createEsxCfgInfoBundle(hostMoRef, fileLayout, esxCfgInfoFile, statsLogger);
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Host '%s' version is '%s', which is before " + MIN_SUPPORTED_HOST_VERSION + ", skipping this host.", hostMoRefId, hostVersion));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createEsxCfgInfoBundle(ManagedObjectReference hostMoRef, EsxFileLayout fileLayout, File esxCfgInfoFile, StatsLogger statsLogger) {
        if (esxCfgInfoFile != null) {
            File rtuZipFile = fileLayout.getRTUZipFileForHostEsxCfg(hostMoRef);
            if (esxCfgInfoFile != null) {
                try {
                    long start = System.currentTimeMillis();
                    Zip.zip(esxCfgInfoFile, rtuZipFile);
                    long end = System.currentTimeMillis();
                    statsLogger.append("timeToArchiveEsxcfgIntoZipOfSize_" + rtuZipFile.length() + "\t" + (end - start));
                }
                catch (IOException e) {
                }
                finally {
                    esxCfgInfoFile.delete();
                }
            }
            return rtuZipFile;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Failed to collect configuration data from host " + hostMoRef.getValue()));
        }
        return null;
    }

    private void collectVcAboutInfo(EsxFileLayout fileLayout, StatsLogger statsLogger) {
        block2: {
            File vcCollectionFolder = fileLayout.getVcWorkFolder();
            statsLogger.append("vcCollectionStart\t" + System.currentTimeMillis());
            AboutInfo aboutInfo = this._vcClient.getServiceInstanceContent().getAbout();
            aboutInfo.setDynamicType(null);
            aboutInfo.setDynamicProperty(null);
            this._jacksonSerializer.writeObject(aboutInfo, AboutInfo.class, vcCollectionFolder);
            try {
                File vcDataZip = fileLayout.getRTUZipFileForVcData();
                Zip.zip(vcCollectionFolder, vcDataZip);
            }
            catch (IOException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Failed to create VC data bundle.");
            }
        }
        statsLogger.append("vcCollectionEnd\t" + System.currentTimeMillis());
    }

    private File createVSphereBundle(EsxFileLayout fileLayout) {
        File vSphereBundle;
        block2: {
            File readyToUploadFolder = fileLayout.getReadyToUploadFolder();
            File statsFile = fileLayout.getPerformanceStatsFile();
            vSphereBundle = null;
            try {
                FileUtils.moveFileToDirectory((File)statsFile, (File)readyToUploadFolder, (boolean)false);
                vSphereBundle = this.createTarFile(readyToUploadFolder);
            }
            catch (IOException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Failed to copy the collection stats log to the ready-to-upload folder.");
            }
        }
        return vSphereBundle;
    }

    private File createTarFile(File workingFolder) {
        Collection listFiles = FileUtils.listFiles((File)workingFolder, null, (boolean)true);
        Tar tar = new Tar(listFiles);
        File destination = new File(workingFolder.getAbsolutePath() + ".tar");
        try {
            tar.createBundle(destination);
        }
        catch (Exception e) {
            String message = "Failed to create TAR archive " + destination.getAbsolutePath();
            if (_log.isWarnEnabled()) {
                _log.warn((Object)message, (Throwable)e);
            }
            throw new RuntimeException(message, e);
        }
        return destination;
    }

    static class EsxFileLayoutFactory {
        EsxFileLayoutFactory() {
        }

        public EsxFileLayout createEsxFileLayout() throws IOException {
            return new EsxFileLayout();
        }
    }
}

