/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.fcd.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.fcd.collector.dataretriever.FcdDataRetrieverHelper;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.fault.FileFault;
import com.vmware.vim.binding.vim.fault.InvalidDatastore;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.vslm.ID;
import com.vmware.vim.binding.vim.vslm.VStorageObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VStorageObjectRetriever
implements DataRetriever<VStorageObject> {
    private static final Log _log = LogFactory.getLog(VStorageObjectRetriever.class);
    private final VcClient _vcClient;
    private final int _queryOffset;
    private final int _queryLimit;

    public VStorageObjectRetriever(VcClient vcClient, int queryOffset, int queryLimit) {
        this._vcClient = vcClient;
        this._queryOffset = queryOffset;
        this._queryLimit = queryLimit;
    }

    @Override
    public List<VStorageObject> retrieveData() {
        FcdDataRetrieverHelper fcdDataRetrieverHelper = new FcdDataRetrieverHelper(this._vcClient);
        TreeMap<ID, ManagedObjectReference> fcdIdToDatastoreMap = fcdDataRetrieverHelper.getSortedFcdIdToDatastoreMap();
        int startInd = this._queryOffset;
        int lastInd = Math.min(this._queryOffset + this._queryLimit, fcdIdToDatastoreMap.keySet().size()) - 1;
        ArrayList<VStorageObject> vStorageObjectList = new ArrayList<VStorageObject>(lastInd - startInd + 1);
        NavigableSet<ID> fcdIds = fcdIdToDatastoreMap.navigableKeySet();
        int curIndex = 0;
        for (ID id : fcdIds) {
            block4: {
                if (curIndex > lastInd) break;
                if (curIndex >= startInd) {
                    try {
                        vStorageObjectList.add(fcdDataRetrieverHelper.getVStorageObjectManager().retrieveVStorageObject(id, fcdIdToDatastoreMap.get(id)));
                    }
                    catch (FileFault | InvalidDatastore | NotFound e) {
                        if (!_log.isDebugEnabled()) break block4;
                        _log.debug((Object)"Error occurred while retrieving VStorageObjects", e);
                    }
                }
            }
            ++curIndex;
        }
        return vStorageObjectList;
    }

    @Override
    public String getKey(VStorageObject t) {
        return t.getConfig().getId().getId();
    }
}

