/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.spbm.SpbmDataProviderImpl;
import com.vmware.ph.phservice.provider.spbm.client.common.context.XServiceClientContext;
import com.vmware.ph.phservice.provider.spbm.client.common.context.XServiceClientContextBuilder;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClientBuilder;
import com.vmware.ph.phservice.provider.spbm.client.sms.SmsServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.sms.SmsServiceClientBuilder;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimDataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;

public class SpbmDataProvidersConnectionImpl
extends VimDataProvidersConnection {
    private final Object _lock = new Object();
    private PbmServiceClient _pbmClient;
    private SmsServiceClient _smsClient;

    public SpbmDataProvidersConnectionImpl(VimContext vimContext) {
        super(vimContext);
    }

    public SpbmDataProvidersConnectionImpl(VimContext vimContext, VcClientProvider vcClientProvider) {
        super(vimContext, vcClientProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataProvider> getDataProviders() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            VcClient vcClient = this.getVcClient();
            XServiceClientContext pbmXServiceClientContext = XServiceClientContextBuilder.newInstance(vcClient).withThumbprintVerifier(this._vimContext.getThumprintVerifier()).withTrustStore(this._vimContext.getVimTrustedStore()).withTimeoutMs(180000).withExecutor(Executors.newSingleThreadExecutor()).build();
            XServiceClientContext smsXServiceClientContext = XServiceClientContextBuilder.newInstance(vcClient).withThumbprintVerifier(this._vimContext.getThumprintVerifier()).withTrustStore(this._vimContext.getVimTrustedStore()).withTimeoutMs(180000).withExecutor(Executors.newSingleThreadExecutor()).build();
            this._pbmClient = PbmServiceClientBuilder.newInstance(pbmXServiceClientContext).build();
            this._smsClient = SmsServiceClientBuilder.newInstance(smsXServiceClientContext).build();
            SpbmCollectorContext spbmCollectorContext = new SpbmCollectorContext(this._pbmClient, this._smsClient);
            ArrayList<SpbmDataProviderImpl> dataProviders = new ArrayList<SpbmDataProviderImpl>();
            dataProviders.add(new SpbmDataProviderImpl(spbmCollectorContext));
            return Collections.unmodifiableList(dataProviders);
        }
    }

    @Override
    public void close() {
        if (this._pbmClient != null) {
            this._pbmClient.close();
        }
        if (this._smsClient != null) {
            this._smsClient.close();
        }
        super.close();
    }
}

