/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.client.sms.impl;

import com.vmware.ph.phservice.provider.spbm.client.common.context.XServiceClientContext;
import com.vmware.ph.phservice.provider.spbm.client.sms.SmsServiceClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.sms.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.net.URI;
import java.util.concurrent.ExecutorService;

public class SmsServiceClientImpl
implements SmsServiceClient {
    private final XServiceClientContext _xServiceClientContext;
    private final VmodlContext vmodlContext;
    private final VcClient vcClient;
    private final Client vmomiClient;
    private final Class<?> vmodlVersion;
    private final Object lock = new Object();
    private ServiceInstance smsServiceInstance;

    public SmsServiceClientImpl(Client vmomiClient, XServiceClientContext xServiceClientContext) {
        this._xServiceClientContext = xServiceClientContext;
        this.vmodlContext = VmodlContext.getContext();
        this.vcClient = this._xServiceClientContext.getVcClient();
        this.vmomiClient = vmomiClient;
        this.vmodlVersion = this._xServiceClientContext.getxClientVmodlVersion();
    }

    @Override
    public URI getServiceUri() {
        return this.vmomiClient.getBinding().getEndpointUri();
    }

    @Override
    public Client getVmomiClient() {
        return this.vmomiClient;
    }

    @Override
    public VmodlVersion getVmodlVersion() {
        return VmodlVersionMap.Factory.getVmodlVersionMap().getVersion(this.vmodlVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInstance getServiceInstance() {
        Object object = this.lock;
        synchronized (object) {
            if (this.smsServiceInstance == null) {
                ManagedObjectReference smsServiceInstanceMoRef = new ManagedObjectReference("SmsServiceInstance", "ServiceInstance");
                ServiceInstance smsServiceInstance = (ServiceInstance)this.createStub(smsServiceInstanceMoRef);
                return smsServiceInstance;
            }
        }
        return this.smsServiceInstance;
    }

    @Override
    public void close() {
        if (this.getXServiceClientContext().getExecutor() != null) {
            ExecutorService service = (ExecutorService)this.getXServiceClientContext().getExecutor();
            service.shutdownNow();
        }
        if (this.vmomiClient != null) {
            this.vmomiClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> T createStub(ManagedObjectReference moRef) {
        VmodlType vmodlType = this.vmodlContext.getVmodlTypeMap().getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ManagedObject managedObject = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            managedObject = this.vmomiClient.createStub(typeClass, moRef);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        RequestContext reqContext = ((Stub)managedObject)._getRequestContext();
        if (reqContext == null) {
            reqContext = new RequestContextImpl();
        }
        if (this.vmomiClient.getBinding().getSession() != null) {
            reqContext.put((Object)"vcSessionCookie", (Object)this.vmomiClient.getBinding().getSession().getId());
        }
        ((Stub)managedObject)._setRequestContext(reqContext);
        return (T)managedObject;
    }

    @Override
    public VmodlContext getVmodlContext() {
        return this.vmodlContext;
    }

    @Override
    public VcClient getVcClient() {
        return this.vcClient;
    }

    @Override
    public XServiceClientContext getXServiceClientContext() {
        return this._xServiceClientContext;
    }
}

