/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClient;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.provider.CapabilityObjectSchema;
import com.vmware.vim.binding.pbm.capability.provider.LineOfServiceInfo;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.QueryProfileResult;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.ResourceTypeEnum;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.binding.pbm.replication.QueryReplicationGroupResult;
import com.vmware.vim.binding.pbm.replication.ReplicationManager;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryReplicationGroupResultRetriever
implements DataRetriever<QueryReplicationGroupResult> {
    private static final Log log = LogFactory.getLog(QueryReplicationGroupResultRetriever.class);
    private static final String DATA_SERVICE_NS = "com.vmware.storageprofile.dataservice";
    private final PbmServiceClient _pbmClient;

    public QueryReplicationGroupResultRetriever(SpbmCollectorContext collectorContext) {
        this._pbmClient = collectorContext.getPbmServiceClient();
    }

    @Override
    public List<QueryReplicationGroupResult> retrieveData() {
        List<QueryReplicationGroupResult> replicationGroupResultList = Collections.emptyList();
        try {
            ProfileManager profileManager;
            ProfileId[] replicationProfileIds;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating ProfileManager stub.");
            }
            if ((replicationProfileIds = QueryReplicationGroupResultRetriever.getRequirementProfilesWithReplicationCapabilities(profileManager = this._pbmClient.getProfileManager())).length != 0) {
                BlockingFuture futureForQueryProfileResult = new BlockingFuture();
                profileManager.queryAssociatedEntities(replicationProfileIds, (Future)futureForQueryProfileResult);
                QueryProfileResult[] queryProfileResult = (QueryProfileResult[])futureForQueryProfileResult.get();
                if (queryProfileResult != null && queryProfileResult.length > 0) {
                    ServerObjectRef[] entities = new ServerObjectRef[queryProfileResult.length];
                    for (int i = 0; i < queryProfileResult.length; ++i) {
                        entities[i] = queryProfileResult[i].getObject();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Creating ReplicationManager stub to retrieve QueryReplicationGroupResult");
                    }
                    ReplicationManager replicationManager = (ReplicationManager)this._pbmClient.createStub(this._pbmClient.getServiceInstanceContent().getReplicationManager());
                    BlockingFuture future = new BlockingFuture();
                    replicationManager.queryReplicationGroups(entities, (Future)future);
                    QueryReplicationGroupResult[] replicationGroupResult = (QueryReplicationGroupResult[])future.get();
                    if (replicationGroupResult != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Retrieved queryReplicationGroupResult");
                        }
                        replicationGroupResultList = new LinkedList<QueryReplicationGroupResult>();
                        for (QueryReplicationGroupResult result : replicationGroupResult) {
                            if (result.getReplicationGroupId() == null) continue;
                            replicationGroupResultList.add(result);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Failed to return queryReplicationGroupResult..");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No VM/disk entities associated with profile.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No requirement profiles with replication capabilities.");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)"Error occurred while retrieving QueryReplicationGroupResult", (Throwable)e);
        }
        return replicationGroupResultList;
    }

    @Override
    public String getKey(QueryReplicationGroupResult t) {
        return t.getObject().getKey();
    }

    private static ProfileId[] getRequirementProfilesWithReplicationCapabilities(ProfileManager profileManager) throws InterruptedException, ExecutionException {
        List<String> replicationNamespaces = QueryReplicationGroupResultRetriever.getReplicationNamespaces(profileManager);
        List<ProfileId> replicationProfileIds = Collections.emptyList();
        if (!replicationNamespaces.isEmpty()) {
            Profile[] profiles = QueryReplicationGroupResultRetriever.getAllProfilesOfGivenCategory(profileManager, CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT.toString().toString());
            if (profiles != null) {
                replicationProfileIds = new ArrayList(profiles.length);
                List<String> dspIdsWithReplication = QueryReplicationGroupResultRetriever.getDspIdsWithReplication(profileManager, replicationNamespaces);
                for (Profile profile : profiles) {
                    CapabilityBasedProfile capBasedProfile;
                    if (!(profile instanceof CapabilityBasedProfile) || !QueryReplicationGroupResultRetriever.hasReplicationCapabilities(capBasedProfile = (CapabilityBasedProfile)profile, replicationNamespaces, dspIdsWithReplication)) continue;
                    replicationProfileIds.add(profile.getProfileId());
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No replication namespaces advertised.");
        }
        return replicationProfileIds.toArray(new ProfileId[replicationProfileIds.size()]);
    }

    private static List<String> getReplicationNamespaces(ProfileManager profileManager) throws InterruptedException, ExecutionException {
        String[] los = new String[]{LineOfServiceInfo.LineOfServiceEnum.REPLICATION.toString()};
        BlockingFuture future = new BlockingFuture();
        profileManager.fetchCapabilitySchema(null, los, (Future)future);
        CapabilityObjectSchema[] capabilityObjectSchemas = (CapabilityObjectSchema[])future.get();
        if (capabilityObjectSchemas != null) {
            ArrayList<String> replicationNamespaces = new ArrayList<String>(capabilityObjectSchemas.length);
            for (CapabilityObjectSchema capabilityObjectSchema : capabilityObjectSchemas) {
                String namespace = capabilityObjectSchema.getNamespaceInfo().getNamespace();
                replicationNamespaces.add(namespace);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("REPLICATION NAMESPACE : " + namespace));
            }
            return replicationNamespaces;
        }
        return Collections.emptyList();
    }

    private static Profile[] getAllProfilesOfGivenCategory(ProfileManager profileManager, String profileCategory) throws InterruptedException, ExecutionException {
        BlockingFuture futureForProfileId = new BlockingFuture();
        ResourceType resourceType = new ResourceType();
        resourceType.setResourceType(ResourceTypeEnum.STORAGE.toString());
        profileManager.queryProfile(resourceType, profileCategory, (Future)futureForProfileId);
        ProfileId[] profileIds = (ProfileId[])futureForProfileId.get();
        Profile[] profiles = null;
        if (profileIds != null) {
            BlockingFuture futureForProfile = new BlockingFuture();
            profileManager.retrieveContent(profileIds, (Future)futureForProfile);
            profiles = (Profile[])futureForProfile.get();
        }
        return profiles;
    }

    private static List<String> getDspIdsWithReplication(ProfileManager profileManager, List<String> replicationNamespaces) throws InterruptedException, ExecutionException {
        Profile[] allDsps = QueryReplicationGroupResultRetriever.getAllProfilesOfGivenCategory(profileManager, CapabilityBasedProfile.ProfileCategoryEnum.DATA_SERVICE_POLICY.toString());
        List<String> replicationDspIds = Collections.emptyList();
        if (allDsps != null) {
            replicationDspIds = new ArrayList<String>(allDsps.length);
            for (Profile profile : allDsps) {
                CapabilityBasedProfile capBasedProfile;
                if (!(profile instanceof CapabilityBasedProfile) || !QueryReplicationGroupResultRetriever.hasReplicationCapabilities(capBasedProfile = (CapabilityBasedProfile)profile, replicationNamespaces, null)) continue;
                replicationDspIds.add(profile.getProfileId().getUniqueId());
            }
        }
        return replicationDspIds;
    }

    private static boolean hasReplicationCapabilities(CapabilityBasedProfile capBasedProfile, List<String> replicationNamespaces, List<String> dspsWithReplication) throws InterruptedException, ExecutionException {
        boolean result = false;
        if (capBasedProfile.getConstraints() instanceof SubProfileCapabilityConstraints) {
            SubProfileCapabilityConstraints capabilityConstraints = (SubProfileCapabilityConstraints)capBasedProfile.getConstraints();
            for (SubProfileCapabilityConstraints.SubProfile subProfile : capabilityConstraints.getSubProfiles()) {
                CapabilityInstance[] capInstances;
                for (CapabilityInstance capInstance : capInstances = subProfile.getCapability()) {
                    boolean isDataServiceReplicationCapability;
                    boolean isReplicationCapability = replicationNamespaces != null && replicationNamespaces.contains(capInstance.getId().getNamespace());
                    boolean isDataServiceNamespace = capInstance.getId().getNamespace().equals(DATA_SERVICE_NS);
                    boolean bl = isDataServiceReplicationCapability = isDataServiceNamespace && dspsWithReplication != null && dspsWithReplication.contains(capInstance.getId().getId());
                    if (!isReplicationCapability && !isDataServiceReplicationCapability) continue;
                    result = true;
                }
            }
        }
        return result;
    }
}

