/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.spbm.client.sms.SmsServiceClient;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.vim.binding.sms.ServiceInstance;
import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.sms.provider.VasaProvider;
import com.vmware.vim.binding.sms.provider.VasaProviderInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VasaProviderInfoRetriever
implements DataRetriever<VasaProviderInfo> {
    private static final Log log = LogFactory.getLog(VasaProviderInfoRetriever.class);
    private final SmsServiceClient _smsClient;

    public VasaProviderInfoRetriever(SpbmCollectorContext collectorContext) {
        this._smsClient = collectorContext.getSmsServiceClient();
    }

    @Override
    public List<VasaProviderInfo> retrieveData() {
        List<VasaProviderInfo> vasaProviderInfoList = Collections.emptyList();
        StorageManager storageManager = this.createStorageManagerStub();
        try {
            BlockingFuture result = new BlockingFuture();
            storageManager.queryProvider((Future)result);
            ManagedObjectReference[] provider = (ManagedObjectReference[])result.get();
            if (provider != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating VasaProvider stub to retrieve providerInfo");
                }
                vasaProviderInfoList = new ArrayList<VasaProviderInfo>(provider.length);
                for (int i = 0; i < provider.length; ++i) {
                    VasaProvider vasaProvider = (VasaProvider)this._smsClient.createStub(provider[i]);
                    VasaProviderInfo providerInfo = (VasaProviderInfo)vasaProvider.queryProviderInfo();
                    vasaProviderInfoList.add(providerInfo);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No providers present in the environment");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)"Error occured while retrieving providers", (Throwable)e);
        }
        return vasaProviderInfoList;
    }

    private StorageManager createStorageManagerStub() {
        StorageManager storageManager = null;
        try {
            ServiceInstance smsServiceInstance = this._smsClient.getServiceInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating StorageManager stub to retrieve Providers");
            }
            BlockingFuture result = new BlockingFuture();
            smsServiceInstance.queryStorageManager((Future)result);
            ManagedObjectReference storageManagerMor = (ManagedObjectReference)result.get();
            storageManager = (StorageManager)this._smsClient.createStub(storageManagerMor);
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)"Error occured getting StorageManager", (Throwable)e);
        }
        return storageManager;
    }

    @Override
    public String getKey(VasaProviderInfo t) {
        return t.getUid();
    }
}

