/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.system.monitor;

import com.vmware.appliance.Monitoring;
import com.vmware.appliance.MonitoringTypes;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.net.URI;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplianceManagementUtil {
    private static final Log log = LogFactory.getLog(ApplianceManagementUtil.class);
    private static final String APPLMGMT_PRODUCT_ID = "com.vmware.applmgmt";
    private static final String APPLMGMT_TYPE_ID = "applmgmt";
    private static final String APPLMGMT_ENDPOINT_PUBLIC_PROTOCOL_ID = "vapi.json.https.public";
    private static final String APPLMGMT_ENDPOINT_TYPE_ID = "com.vmware.applmgmt";

    public static URI discoverApplianceMgmtUri(VimContext vimContext) throws Exception {
        LookupClient lookupClient = vimContext.getLookupClientBuilder(true).build();
        ServiceRegistration serviceRegistration = lookupClient.getServiceRegistration();
        if (serviceRegistration == null) {
            return null;
        }
        ServiceRegistration.Info vcServiceInfo = serviceRegistration.get(vimContext.getVcInstanceUuid());
        if (vcServiceInfo == null) {
            return null;
        }
        String nodeId = vcServiceInfo.getNodeId();
        ServiceRegistration.Filter searchFilter = new ServiceRegistration.Filter();
        searchFilter.setServiceType(new ServiceRegistration.ServiceType("com.vmware.applmgmt", APPLMGMT_TYPE_ID));
        searchFilter.setEndpointType(new ServiceRegistration.EndpointType(APPLMGMT_ENDPOINT_PUBLIC_PROTOCOL_ID, "com.vmware.applmgmt"));
        searchFilter.setNodeId(nodeId);
        ServiceRegistration.Info[] applMgmtServices = serviceRegistration.list(searchFilter);
        if (applMgmtServices == null) {
            return null;
        }
        ServiceRegistration.Endpoint[] serviceEndpoints = applMgmtServices[0].getServiceEndpoints();
        if (serviceEndpoints == null) {
            return null;
        }
        return serviceEndpoints[0].getUrl();
    }

    public static Map<String, List<String>> getMonitoredItemsData(Monitoring monitoringService, List<String> monitoredItemNames, int lastXMinutes) throws Exception {
        MonitoringTypes.MonitoredItemDataRequest dataRequest = new MonitoringTypes.MonitoredItemDataRequest();
        dataRequest.setNames(monitoredItemNames);
        dataRequest.setFunction(MonitoringTypes.FunctionType.AVG);
        dataRequest.setInterval(MonitoringTypes.IntervalType.MINUTES5);
        Calendar end = Calendar.getInstance();
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(end.getTimeInMillis() - (long)(lastXMinutes * 60 * 1000));
        dataRequest.setStartTime(start);
        dataRequest.setEndTime(end);
        if (log.isTraceEnabled()) {
            log.trace((Object)("dataRequest sent to query() method: " + dataRequest));
        }
        List results = monitoringService.query(dataRequest);
        if (log.isTraceEnabled()) {
            log.trace((Object)("results received from query() method: " + results));
        }
        LinkedHashMap<String, List<String>> nameToData = new LinkedHashMap<String, List<String>>();
        for (String monitoredItemName : monitoredItemNames) {
            nameToData.put(monitoredItemName, null);
        }
        for (MonitoringTypes.MonitoredItemData data : results) {
            if (!monitoredItemNames.contains(data.getName())) continue;
            nameToData.put(data.getName(), data.getData());
        }
        return nameToData;
    }
}

