/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.system.monitor;

import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitor;
import com.vmware.ph.phservice.provider.system.monitor.impl.ApplianceSystemLoadMonitor;
import com.vmware.ph.phservice.provider.system.monitor.impl.DummySystemLoadMonitor;
import com.vmware.ph.phservice.provider.system.monitor.impl.SigarLocalSystemLoadMonitor;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import org.apache.commons.lang.SystemUtils;

public class SystemLoadMonitorFactory {
    static final String CPU_USED_PROPERTY = "dev.systemLoadMonitor.usedCpu";
    static final String MEMORY_USED_PROPERTY = "dev.systemLoadMonitor.usedMem";
    static final String MEMORY_TOTAl_PROPERTY = "dev.systemLoadMonitor.totalMem";

    public SystemLoadMonitor createSystemLoadMonitor(VimContext vimContext) {
        SystemLoadMonitor systemLoadMonitor = null;
        SystemLoadMonitor dummySystemLoadMonitor = SystemLoadMonitorFactory.createDummySystemLoadMonitor();
        systemLoadMonitor = dummySystemLoadMonitor != null ? dummySystemLoadMonitor : (vimContext != null && !this.isWindowsOS() ? new ApplianceSystemLoadMonitor(vimContext) : new SigarLocalSystemLoadMonitor());
        return systemLoadMonitor;
    }

    boolean isWindowsOS() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    private static SystemLoadMonitor createDummySystemLoadMonitor() {
        String cpuUsedPropertyValue = System.getProperty(CPU_USED_PROPERTY);
        String memUsedPropertyValue = System.getProperty(MEMORY_USED_PROPERTY);
        String memTotalPropertyValue = System.getProperty(MEMORY_TOTAl_PROPERTY);
        if (cpuUsedPropertyValue == null || memUsedPropertyValue == null || memTotalPropertyValue == null) {
            return null;
        }
        Double cpuUsed = Double.parseDouble(cpuUsedPropertyValue);
        Double memUsed = Double.parseDouble(memUsedPropertyValue);
        Double memTotal = Double.parseDouble(memTotalPropertyValue);
        return new DummySystemLoadMonitor(cpuUsed, memUsed, memTotal);
    }
}

