/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.system.monitor.impl;

import com.vmware.appliance.Monitoring;
import com.vmware.ph.phservice.provider.system.monitor.ApplianceManagementUtil;
import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitor;
import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitorException;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.vapicommon.client.VapiClient;
import com.vmware.ph.phservice.vapicommon.client.VapiClientFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplianceSystemLoadMonitor
implements SystemLoadMonitor {
    private final VimContext _vimContext;
    private final VapiClientFactory _vapiClientFactory;

    public ApplianceSystemLoadMonitor(VimContext vimContext) {
        this._vimContext = vimContext;
        this._vapiClientFactory = new VapiClientFactory(this._vimContext.getVimTrustedStore());
    }

    @Override
    public Map<String, Double> getAverageValuesForMonitoredItems(List<String> monitoredItemNames, int lastXMinutes) throws SystemLoadMonitorException {
        HashMap<String, Double> monitoredItemsAverageValues = new HashMap<String, Double>(monitoredItemNames.size());
        try (VapiClient vapiClient = this.createVapiClient();){
            Monitoring monitoringService = vapiClient.createStub(Monitoring.class);
            Map<String, List<String>> monitoredItemsData = ApplianceManagementUtil.getMonitoredItemsData(monitoringService, monitoredItemNames, lastXMinutes);
            for (Map.Entry<String, List<String>> dataEntry : monitoredItemsData.entrySet()) {
                String dataStringValue = this.extractValueFromDataValueList(dataEntry.getValue());
                if (dataStringValue == null) {
                    String message = String.format("Cannot extract non-empty value for monitored item %s. Data array: %s", dataEntry.getKey(), dataEntry.getValue());
                    throw new SystemLoadMonitorException(message);
                }
                Double dataValue = Double.parseDouble(dataStringValue);
                monitoredItemsAverageValues.put(dataEntry.getKey(), dataValue);
            }
        }
        catch (SystemLoadMonitorException slme) {
            throw slme;
        }
        catch (Exception e) {
            throw new SystemLoadMonitorException(e);
        }
        return monitoredItemsAverageValues;
    }

    private String extractValueFromDataValueList(List<String> dataArray) {
        for (String item : dataArray) {
            if ("".equals(item)) continue;
            return item;
        }
        return null;
    }

    VapiClient createVapiClient() throws Exception {
        URI applianceManagementUri = ApplianceManagementUtil.discoverApplianceMgmtUri(this._vimContext);
        if (applianceManagementUri == null) {
            throw new IllegalStateException("Unable to locate appliance management uri");
        }
        return this._vapiClientFactory.createClient(applianceManagementUri, this._vimContext.getSsoTokenProvider());
    }
}

