/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.system.monitor.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibraryLoader {
    private static final Log log = LogFactory.getLog(NativeLibraryLoader.class);
    private final WriteToFileUtil writeToFileUtil;
    private final TempFileOperationsWrapper tempFileOperationsWrapper;
    private final SystemLoadWrapper systemLoadWrapper;

    public NativeLibraryLoader() {
        this(new WriteToFileUtil(), new TempFileOperationsWrapper(), new SystemLoadWrapper());
    }

    NativeLibraryLoader(WriteToFileUtil writeToFileUtil, TempFileOperationsWrapper tempFileOperationsWrapper, SystemLoadWrapper systemLoadWrapper) {
        this.tempFileOperationsWrapper = tempFileOperationsWrapper;
        this.writeToFileUtil = writeToFileUtil;
        this.systemLoadWrapper = systemLoadWrapper;
    }

    public void loadLibraryFromJar(String path) throws NativeLibraryLoaderException {
        log.debug((Object)"Start loading native library from current JAR file");
        if (!path.startsWith("/")) {
            throw new NativeLibraryLoaderException(new IllegalArgumentException("The path has to be absolute (start with '/')."));
        }
        String nativeLibFileName = this.getFileNameFromPath(path);
        log.debug((Object)("Native library filename = " + nativeLibFileName));
        String[] parts = this.getFilenamePrefixAndSuffix(nativeLibFileName);
        log.debug((Object)("Native library filename prefix = " + parts[0] + " and suffix = " + parts[1]));
        try {
            this.tempFileOperationsWrapper.deleteTempFiles(parts[0], parts[1]);
            File temp = this.createTempFile(parts[0], parts[1]);
            this.writeNativeLibToTempFile(path, temp);
            String tempFileAbsPath = temp.getAbsolutePath();
            log.debug((Object)("Loading native library from temp file: " + tempFileAbsPath));
            this.systemLoadWrapper.load(tempFileAbsPath);
            log.debug((Object)("Successfully loaded native library " + path));
        }
        catch (Throwable e) {
            log.debug((Object)("There was " + e.getClass().getSimpleName() + " exception and the native library " + path + " was not loaded"));
            throw new NativeLibraryLoaderException(e);
        }
    }

    private String[] getFilenamePrefixAndSuffix(String filename) throws NativeLibraryLoaderException {
        String prefix = null;
        String suffix = null;
        if (filename != null) {
            String[] parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            log.debug((Object)("ERROR: provided native library filename " + filename + " must be at least 3 characters long"));
            throw new NativeLibraryLoaderException(new IllegalArgumentException("The filename has to be at least 3 characters long."));
        }
        return new String[]{prefix, suffix};
    }

    private String getFileNameFromPath(String path) {
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        return filename;
    }

    private File createTempFile(String prefix, String suffix) throws IOException, FileNotFoundException {
        File temp = this.tempFileOperationsWrapper.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        log.debug((Object)("Created temp file: " + temp.getAbsolutePath()));
        if (!temp.exists()) {
            log.debug((Object)("ERROR: File " + temp.getAbsolutePath() + " does not exist."));
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNativeLibToTempFile(String path, File temp) throws FileNotFoundException, IOException {
        log.debug((Object)("Loading native library " + path + " as resource"));
        InputStream is = NativeLibraryLoader.class.getResourceAsStream(path);
        if (is == null) {
            log.debug((Object)("ERROR: Could not load native library " + temp.getAbsolutePath() + " as resource."));
            throw new FileNotFoundException("Native library " + path + " was not found inside JAR.");
        }
        log.debug((Object)("Writing native library " + path + " to temp file: " + temp.getAbsolutePath()));
        try {
            this.writeToFileUtil.writeToFile(is, temp);
        }
        finally {
            is.close();
        }
    }

    static class TempFileOperationsWrapper {
        private static final Log log = LogFactory.getLog(TempFileOperationsWrapper.class);

        TempFileOperationsWrapper() {
        }

        public File createTempFile(String prefix, String suffix) throws IOException {
            return File.createTempFile(prefix, suffix);
        }

        public void deleteTempFiles(final String prefix, final String suffix) {
            File[] files;
            File tmpDir = FileUtils.getTempDirectory();
            log.debug((Object)("temp directory = " + tmpDir.getAbsolutePath()));
            for (File f : files = tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.startsWith(prefix) && filename.endsWith(suffix);
                }
            })) {
                log.debug((Object)("deleting file : " + f.getAbsolutePath()));
                f.delete();
            }
        }
    }

    static class SystemLoadWrapper {
        SystemLoadWrapper() {
        }

        public void load(String fileName) {
            System.load(fileName);
        }
    }

    static class WriteToFileUtil {
        WriteToFileUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToFile(InputStream is, File dest) throws IOException {
            byte[] buffer = new byte[1024];
            try (FileOutputStream os = new FileOutputStream(dest);){
                int readBytes;
                while ((readBytes = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
        }
    }

    public static class NativeLibraryLoaderException
    extends Exception {
        public NativeLibraryLoaderException(Throwable t) {
            super(t);
        }
    }
}

