/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.Builder;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.vcenter.alarms.AlarmsDataProviderImpl;
import com.vmware.ph.phservice.provider.vcenter.event.EventsDataProvider;
import com.vmware.ph.phservice.provider.vcenter.extensions.ExtensionsDataProvider;
import com.vmware.ph.phservice.provider.vcenter.mo.InternalSingletonMoDataProvider;
import com.vmware.ph.phservice.provider.vcenter.mo.SingletonMoDataProvider;
import com.vmware.ph.phservice.provider.vcenter.mo.SingletonMoMethodDataProviderFactory;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetricsDataProvider;
import com.vmware.ph.phservice.provider.vcenter.resourcemodel.PcResourceModelDataProviderImpl;
import com.vmware.ph.phservice.provider.vcenter.resourcemodel.RiseResourceModelDataProviderImpl;
import com.vmware.ph.phservice.provider.vimcommon.mo.MoMethodDataProvider;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.cis.data.provider.version.version1;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.Arrays;
import java.util.List;

public class VcDataProvidersConnectionImpl
implements DataProvidersConnection {
    private Builder<VcClient> _vcClientBuilder;
    private VcClient _vcClient;
    private final boolean _shouldDisposeClient;

    public VcDataProvidersConnectionImpl(Builder<VcClient> vcClientBuilder) {
        this._vcClientBuilder = vcClientBuilder;
        this._shouldDisposeClient = true;
    }

    public VcDataProvidersConnectionImpl(VcClient vcClient) {
        this._vcClient = vcClient;
        this._shouldDisposeClient = false;
    }

    @Override
    public List<DataProvider> getDataProviders() throws Exception {
        if (this._vcClient == null && this._vcClientBuilder != null) {
            this._vcClient = this._vcClientBuilder.build();
        }
        DataProvider resourceModelDataProvider = VcDataProvidersConnectionImpl.createResourceModelDataProvider(this._vcClient);
        AlarmsDataProviderImpl alarmsDataProvider = new AlarmsDataProviderImpl(this._vcClient);
        SingletonMoDataProvider singletonMoDataProvider = new SingletonMoDataProvider(this._vcClient, resourceModelDataProvider);
        InternalSingletonMoDataProvider internalSingletonMoDataProvider = new InternalSingletonMoDataProvider(this._vcClient, singletonMoDataProvider);
        MoMethodDataProvider singletonMoMethodDataProvider = SingletonMoMethodDataProviderFactory.createPublicMoMethodDataProvider(this._vcClient);
        MoMethodDataProvider internalSingletonMoMethodDataProvider = SingletonMoMethodDataProviderFactory.creatInternalMoMethodDataProvider(this._vcClient);
        ExtensionsDataProvider extensionsDataProvider = new ExtensionsDataProvider(this._vcClient);
        EventsDataProvider eventDataProvider = new EventsDataProvider(this._vcClient);
        PerfMetricsDataProvider perfDataProvider = new PerfMetricsDataProvider(this._vcClient);
        return Arrays.asList(resourceModelDataProvider, singletonMoDataProvider, singletonMoMethodDataProvider, internalSingletonMoDataProvider, internalSingletonMoMethodDataProvider, extensionsDataProvider, eventDataProvider, alarmsDataProvider, perfDataProvider);
    }

    @Override
    public void close() {
        if (this._vcClient != null && this._shouldDisposeClient) {
            this._vcClient.close();
        }
    }

    public static DataProvider createResourceModelDataProvider(VcClient vcClient) {
        Object dataProvider = null;
        VmodlVersion riseVersion = vcClient.getVmodlContext().getVmodlVersionMap().getVersion(version1.class);
        dataProvider = riseVersion != null && vcClient.getVmodlVersion().isCompatible(riseVersion) ? new RiseResourceModelDataProviderImpl(vcClient) : new PcResourceModelDataProviderImpl(vcClient);
        return dataProvider;
    }
}

