/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.event;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.ItemsStream;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vcenter.event.EventsReader;
import com.vmware.ph.phservice.provider.vcenter.event.QueryFilterToEventFilterSpecConverter;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventsDataProvider
implements DataProvider {
    private static final String EVENTS_VMODL_PACKAGE_NAME = "com.vmware.vim.binding.vim.event";
    private static final Log _log = LogFactory.getLog(EventsDataProvider.class);
    private final VcClient _vcClient;
    private final QuerySchema _eventQuerySchema;
    private final QueryFilterToEventFilterSpecConverter _queryFilterConverter;

    public EventsDataProvider(VcClient vcClient) {
        this(vcClient, EventsDataProvider.createQuerySchema(vcClient), new QueryFilterToEventFilterSpecConverter());
    }

    EventsDataProvider(VcClient vcClient, QuerySchema eventQuerySchema, QueryFilterToEventFilterSpecConverter filterConverter) {
        this._vcClient = vcClient;
        this._eventQuerySchema = eventQuerySchema;
        this._queryFilterConverter = filterConverter;
    }

    public QuerySchema getSchema() {
        return this._eventQuerySchema;
    }

    public ResultSet executeQuery(Query query) {
        String queryModelName = (String)query.getResourceModels().iterator().next();
        EventFilterSpec eventFilterSpec = this._queryFilterConverter.createEventFilterSpec(queryModelName, query.getFilter());
        EventsReader eventsReader = new EventsReader(this._vcClient, eventFilterSpec);
        return EventsDataProvider.getEventsData(query, eventsReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResultSet getEventsData(Query query, ItemsStream<Event> eventsReader) {
        ResultSet.Builder eventsResultSetBuilder = ResultSet.Builder.properties((List)query.getProperties());
        if (eventsReader != null) {
            try {
                List<Event> vcEvents = PageUtil.pageItems(eventsReader, query.getOffset(), query.getLimit());
                for (Event vcEvent : vcEvents) {
                    EventsDataProvider.addEventDataToResultSet(vcEvent, query.getProperties(), eventsResultSetBuilder);
                }
            }
            finally {
                try {
                    eventsReader.close();
                }
                catch (IOException e) {
                    _log.debug((Object)"Failed to close the Items Stream.", (Throwable)e);
                }
            }
        }
        return eventsResultSetBuilder.build();
    }

    static void addEventDataToResultSet(Event vcEvent, List<String> eventQueryProperties, ResultSet.Builder eventsResultSetBuilder) {
        List<String> nonQualifiedEventQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(eventQueryProperties);
        URI eventModelKey = VimDataProviderUtil.createModelKey(vcEvent.getClass(), String.valueOf(vcEvent.getKey()));
        List<Object> eventQueryPropertyValues = VimDataProviderUtil.getPropertyValues(vcEvent, eventModelKey, nonQualifiedEventQueryProperties);
        eventsResultSetBuilder.item((Object)eventModelKey, eventQueryPropertyValues);
    }

    private static QuerySchema createQuerySchema(VcClient vcClient) {
        VmodlContext vmodlContext = vcClient.getVmodlContext();
        VmodlTypeMap vmodlTypeMap = vmodlContext.getVmodlTypeMap();
        VmodlVersion vmodlVersion = vcClient.getVmodlVersion();
        List<VmodlType> eventDataObjectVmodlTypes = VmodlTypeToQuerySchemaModelInfoConverter.getAllDataObjectVmodlTypesInPackage(vmodlTypeMap, EVENTS_VMODL_PACKAGE_NAME);
        Map<String, QuerySchema.ModelInfo> eventsTypeNameToModelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToWsdlNameModelInfos(eventDataObjectVmodlTypes, vmodlTypeMap, vmodlVersion);
        return QuerySchema.forModels(eventsTypeNameToModelInfo);
    }
}

