/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.extensions;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExtensionsDataProvider
implements DataProvider {
    private static final String EXTENSION_VMODL_TYPE = "Extension";
    private final VcClient _vcClient;
    private final QuerySchema _querySchema;
    private ExtensionManager _extensionManager;

    public ExtensionsDataProvider(VcClient vcClient) {
        this._vcClient = vcClient;
        this._querySchema = ExtensionsDataProvider.createQuerySchema(vcClient);
    }

    ExtensionsDataProvider(VcClient vcClient, QuerySchema querySchema) {
        this._vcClient = vcClient;
        this._querySchema = querySchema;
    }

    public QuerySchema getSchema() {
        return this._querySchema;
    }

    public ResultSet executeQuery(Query query) {
        List queryProperties = query.getProperties();
        List<String> nonQualifiedQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(queryProperties);
        List<Extension> extensions = this.getExtensions(query.getOffset(), query.getLimit());
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)queryProperties);
        for (Extension extension : extensions) {
            URI extensionModelKey = VimDataProviderUtil.createModelKey(Extension.class, extension.getKey());
            List<Object> propertyValues = VimDataProviderUtil.getPropertyValues(extension, extensionModelKey, nonQualifiedQueryProperties);
            resultSetBuilder.item((Object)extensionModelKey, propertyValues);
        }
        return resultSetBuilder.build();
    }

    private List<Extension> getExtensions(int offset, int limit) {
        ExtensionManager extensionManager = this.getExtensionManager();
        if (extensionManager == null) {
            return Collections.emptyList();
        }
        List<Extension> extensionList = ExtensionsDataProvider.retrieveExtensionList(extensionManager);
        return PageUtil.pageItems(extensionList, offset, limit);
    }

    private ExtensionManager getExtensionManager() {
        if (this._extensionManager == null) {
            ManagedObjectReference extensionManagerMoRef = this._vcClient.getServiceInstanceContent().getExtensionManager();
            this._extensionManager = (ExtensionManager)this._vcClient.createMo(extensionManagerMoRef);
        }
        return this._extensionManager;
    }

    private static List<Extension> retrieveExtensionList(ExtensionManager extensionManager) {
        Extension[] extensions = extensionManager.getExtensionList();
        return extensions != null ? Arrays.asList(extensions) : new ArrayList<Extension>();
    }

    private static QuerySchema createQuerySchema(VcClient vcClient) {
        VmodlTypeMap vmodlTypeMap = vcClient.getVmodlContext().getVmodlTypeMap();
        VmodlType extensionVmodlType = vmodlTypeMap.getVmodlType(EXTENSION_VMODL_TYPE);
        VmodlVersion vmodlVersion = vcClient.getVmodlVersion();
        Map<String, QuerySchema.ModelInfo> extensionModels = VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToWsdlNameModelInfos(Collections.singletonList(extensionVmodlType), vmodlTypeMap, vmodlVersion);
        return QuerySchema.forModels(extensionModels);
    }
}

