/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.performance;

import java.util.Arrays;

public enum PerfInterval {
    REALTIME(0),
    DAILY(1),
    WEEKLY(2);

    private final int _key;

    private PerfInterval(int key) {
        this._key = key;
    }

    public int getKey() {
        return this._key;
    }

    public static PerfInterval parse(String internalName) {
        for (PerfInterval perfInterval : PerfInterval.values()) {
            if (!perfInterval.toString().equalsIgnoreCase(internalName)) continue;
            return perfInterval;
        }
        throw new IllegalArgumentException(String.format("Cannot parse string [%s] to PerformanceInterval. Supported interval values are %s.", internalName, Arrays.toString((Object[])PerfInterval.values())));
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

