/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.performance;

import com.vmware.ph.phservice.provider.vcenter.performance.PerfInterval;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetadata;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.PerformanceManager;
import java.util.HashMap;
import java.util.Map;

public class PerfMetadataBuilder {
    private static final int REALTIME_SAMPLING_PERIOD_SECONDS = 20;
    private static final String PERF_COUNTER_NAME_PATTERN = "%s.%s.%s.%s.%s";

    public static PerfMetadata buildPerfMetadata(PerformanceManager.CounterInfo[] counterInfos, HistoricalInterval[] historicalIntervals) {
        HashMap<String, Integer> counterNameToCounterKey = new HashMap<String, Integer>(counterInfos.length);
        HashMap<Integer, String> counterKeyToCounterName = new HashMap<Integer, String>(counterInfos.length);
        PerfMetadataBuilder.mapCounterNamesAndKeys(counterInfos, counterNameToCounterKey, counterKeyToCounterName);
        Map<Integer, Integer> intervalToSamplingPeriod = PerfMetadataBuilder.mapIntervalToSamplingPeriod(historicalIntervals);
        return new PerfMetadata(counterNameToCounterKey, counterKeyToCounterName, intervalToSamplingPeriod);
    }

    private static void mapCounterNamesAndKeys(PerformanceManager.CounterInfo[] counterInfos, Map<String, Integer> counterNameToCounterKey, Map<Integer, String> counterKeyToCounterName) {
        for (PerformanceManager.CounterInfo counterInfo : counterInfos) {
            String counterName = String.format(PERF_COUNTER_NAME_PATTERN, counterInfo.groupInfo.key, counterInfo.nameInfo.key, counterInfo.rollupType, counterInfo.statsType, counterInfo.unitInfo.key);
            int counterKey = counterInfo.getKey();
            counterNameToCounterKey.put(counterName, counterKey);
            counterKeyToCounterName.put(counterKey, counterName);
        }
    }

    private static Map<Integer, Integer> mapIntervalToSamplingPeriod(HistoricalInterval[] historicalIntervals) {
        HashMap<Integer, Integer> intervalKeyToSamplingPeriod = new HashMap<Integer, Integer>(historicalIntervals.length);
        for (HistoricalInterval historicalInterval : historicalIntervals) {
            intervalKeyToSamplingPeriod.put(historicalInterval.key, historicalInterval.samplingPeriod);
        }
        intervalKeyToSamplingPeriod.put(PerfInterval.REALTIME.getKey(), 20);
        return intervalKeyToSamplingPeriod;
    }
}

