/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClientBuilder;
import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProvider;
import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProviderBuilder;
import com.vmware.ph.phservice.ciscommon.sso.impl.LookupSsoEndpointProviderImpl;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;

public class VimContextBuilder {
    private final KeyStore _vimTrustStore;
    private ThumbprintVerifier _vimThumbprintVerifier;
    private boolean _isLegacyVim = false;
    private URI _vcSdkUri;
    private String _vcInstanceUuid;
    private String _vcNodeId;
    private Class<?> _vcVersionClass;
    private String _legacyVcUsername;
    private char[] _legacyVcPassword;
    private URI _lookupSdkUri;
    private String _ssoUsername;
    private char[] _ssoPassword;
    private X509Certificate _solutionCertificate;
    private Key _solutionPrivateKey;
    private SsoTokenProvider.TokenKeyPair _tokenKeyPair;
    private KeyStore _solutionKeyStore;
    private String _solutionKeyAlias;
    private char[] _solutionKeyPassword;

    private VimContextBuilder(URI lookupSdkUri, KeyStore vimTrustStore) {
        this._lookupSdkUri = lookupSdkUri;
        this._vimTrustStore = vimTrustStore;
        this._isLegacyVim = false;
    }

    private VimContextBuilder(URI vcSdkUri, KeyStore vimTrustStore, boolean isLegacyVim) {
        this._vcSdkUri = vcSdkUri;
        this._vimTrustStore = vimTrustStore;
        this._isLegacyVim = true;
    }

    public static VimContextBuilder forVim(URI lookupSdkUri, KeyStore vimTrustStore) {
        return new VimContextBuilder(lookupSdkUri, vimTrustStore);
    }

    public static VimContextBuilder forLegacyVim(URI vcSdkUri, KeyStore vimTrustStore) {
        return new VimContextBuilder(vcSdkUri, vimTrustStore, true);
    }

    public VimContextBuilder withTrust(ThumbprintVerifier vimThumbprintVerifier) {
        this._vimThumbprintVerifier = vimThumbprintVerifier;
        return this;
    }

    public VimContextBuilder withVcInstanceUuid(String vcInstanceUuid) {
        this._vcInstanceUuid = vcInstanceUuid;
        return this;
    }

    public VimContextBuilder withVcSdkUri(URI vcSdkUri) {
        this._vcSdkUri = vcSdkUri;
        return this;
    }

    public VimContextBuilder withVcNodeId(String vcNodeId) {
        this._vcNodeId = vcNodeId;
        return this;
    }

    public VimContextBuilder withVcVersion(Class<?> vcVersionClass) {
        this._vcVersionClass = vcVersionClass;
        return this;
    }

    public VimContextBuilder withLegacyVcUser(String vcUsername, char[] vcPassword) {
        this._legacyVcUsername = vcUsername;
        this._legacyVcPassword = vcPassword;
        return this;
    }

    public VimContextBuilder withSsoUser(String ssoUsername, char[] ssoPassword) {
        this._ssoUsername = ssoUsername;
        this._ssoPassword = ssoPassword;
        return this;
    }

    public VimContextBuilder withSamlTokenAndPrivateKey(SamlToken samlToken, PrivateKey privateKey) {
        this._tokenKeyPair = new SsoTokenProvider.TokenKeyPair();
        this._tokenKeyPair.token = samlToken;
        this._tokenKeyPair.key = privateKey;
        return this;
    }

    public VimContextBuilder withSsoSolutionUser(X509Certificate solutionCertificate, Key solutionPrivateKey) {
        this._solutionCertificate = solutionCertificate;
        this._solutionPrivateKey = solutionPrivateKey;
        return this;
    }

    public VimContextBuilder withSsoSolutionUser(KeyStore solutionKeyStore, String solutionKeyAlias, char[] solutionKeyPassword) {
        this._solutionKeyStore = solutionKeyStore;
        this._solutionKeyAlias = solutionKeyAlias;
        this._solutionKeyPassword = solutionKeyPassword;
        return this;
    }

    public VimContext build() {
        VimContext vimContext = null;
        if (!this._isLegacyVim) {
            LookupClientBuilder lookupClientBuilder = LookupClientBuilder.forLookupVersion(LookupClientBuilder.LEGACY_LOOKUP_VERSION_CLASS, Executors.newSingleThreadExecutor()).withTrust(this._vimTrustStore, this._vimThumbprintVerifier).withLookupSdkUri(this._lookupSdkUri);
            SsoTokenProvider ssoTokenProvider = this.createSsoTokenProvider(lookupClientBuilder);
            if (this._vcInstanceUuid == null && this._vcSdkUri == null && this._vcNodeId == null) {
                throw new IllegalArgumentException("Missing VC context");
            }
            vimContext = new VimContext(this._vimTrustStore, this._lookupSdkUri, lookupClientBuilder, ssoTokenProvider, this._vcInstanceUuid, this._vcSdkUri, this._vcNodeId);
        } else {
            if (this._vcSdkUri == null) {
                throw new IllegalArgumentException("Missing VC context - VC SDK URI");
            }
            vimContext = new VimContext(this._vimTrustStore, this._vcSdkUri, this._legacyVcUsername, this._legacyVcPassword);
        }
        vimContext.setVimThumbprintVerifier(this._vimThumbprintVerifier);
        vimContext.setVcVersionClass(this._vcVersionClass);
        return vimContext;
    }

    private SsoTokenProvider createSsoTokenProvider(LookupClientBuilder lookupClientBuilder) {
        if (this._isLegacyVim) {
            return null;
        }
        LookupSsoEndpointProviderImpl ssoEndpointProvider = new LookupSsoEndpointProviderImpl(lookupClientBuilder);
        SsoTokenProviderBuilder ssoTokenProviderBuilder = SsoTokenProviderBuilder.forSsoService(ssoEndpointProvider).withTrust(this._vimTrustStore, this._vimThumbprintVerifier);
        if (this._ssoUsername != null) {
            ssoTokenProviderBuilder.withSsoUser(this._ssoUsername, this._ssoPassword);
        } else if (this._tokenKeyPair != null) {
            ssoTokenProviderBuilder.withTokenKeyPair(this._tokenKeyPair);
        } else if (this._solutionCertificate != null) {
            ssoTokenProviderBuilder.withSsoSolutionUser(this._solutionCertificate, this._solutionPrivateKey);
        } else if (this._solutionKeyStore != null) {
            ssoTokenProviderBuilder.withSsoSolutionUser(this._solutionKeyStore, this._solutionKeyAlias, this._solutionKeyPassword);
        } else {
            throw new IllegalArgumentException("Missing SSO user");
        }
        SsoTokenProvider ssoTokenProvider = ssoTokenProviderBuilder.build();
        return ssoTokenProvider;
    }
}

