/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.ph.phservice.provider.vimcommon.VmodlUtil;
import com.vmware.ph.phservice.provider.vimcommon.mo.MethodNameToQueryPropertyConverter;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VmodlTypeToQuerySchemaModelInfoConverter {
    public static List<VmodlType> getAllDataObjectVmodlTypesInPackage(VmodlTypeMap vmodlTypeMap, String vmodlPackageName) {
        LinkedList<VmodlType> dataObjectTypes = new LinkedList<VmodlType>();
        List vmodlTypes = vmodlTypeMap.getVmodlTypes();
        for (VmodlType vmodlType : vmodlTypes) {
            if (!DataObject.class.isAssignableFrom(vmodlType.getTypeClass()) || !vmodlType.getTypeClass().getCanonicalName().contains(vmodlPackageName)) continue;
            dataObjectTypes.add(vmodlType);
        }
        return dataObjectTypes;
    }

    public static Map<String, QuerySchema.ModelInfo> convertVmodlTypesToClassNameModelInfos(Collection<VmodlType> vmodlTypes, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        return VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToModelInfos(vmodlTypes, vmodlTypeMap, vmodlVersion, true);
    }

    public static Map<String, QuerySchema.ModelInfo> convertVmodlTypesToWsdlNameModelInfos(Collection<VmodlType> vmodlTypes, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        return VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToModelInfos(vmodlTypes, vmodlTypeMap, vmodlVersion, false);
    }

    public static Map<String, QuerySchema.ModelInfo> convertManagedObjectTypeMethodsToWsdlNameModelInfos(Collection<ManagedObjectType> managedObjectTypes, VmodlVersion vmodlVersion) {
        TreeMap<String, QuerySchema.ModelInfo> models = new TreeMap<String, QuerySchema.ModelInfo>();
        for (ManagedObjectType managedObjectType : managedObjectTypes) {
            List<ManagedMethod> managedObjectMethods = VmodlUtil.getManagedMethods(managedObjectType, vmodlVersion);
            QuerySchema.ModelInfo methodsModelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertManagedObjectMethodsToModelInfo(managedObjectMethods);
            models.put(managedObjectType.getWsdlName(), methodsModelInfo);
        }
        return models;
    }

    private static Map<String, QuerySchema.ModelInfo> convertVmodlTypesToModelInfos(Collection<VmodlType> vmodlTypes, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion, boolean useTypeClassNames) {
        TreeMap<String, QuerySchema.ModelInfo> models = new TreeMap<String, QuerySchema.ModelInfo>();
        for (VmodlType vmodlType : vmodlTypes) {
            List<String> propertyNames = VmodlUtil.getProperties(vmodlType, 4, vmodlTypeMap, vmodlVersion);
            QuerySchema.ModelInfo queryModelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertPropertyNamesToModelInfo(propertyNames);
            if (useTypeClassNames) {
                models.put(vmodlType.getTypeClass().getSimpleName(), queryModelInfo);
                continue;
            }
            models.put(vmodlType.getWsdlName(), queryModelInfo);
        }
        return models;
    }

    public static QuerySchema.ModelInfo convertPropertyNamesToModelInfo(List<String> propertyNames) {
        TreeMap<String, QuerySchema.PropertyInfo> modelInfoProperties = new TreeMap<String, QuerySchema.PropertyInfo>();
        for (String propertyName : propertyNames) {
            modelInfoProperties.put(propertyName, QuerySchema.PropertyInfo.forNonFilterableProperty());
        }
        return new QuerySchema.ModelInfo(modelInfoProperties);
    }

    private static QuerySchema.ModelInfo convertManagedObjectMethodsToModelInfo(List<ManagedMethod> managedObjectMethods) {
        HashMap<String, QuerySchema.PropertyInfo> modelInfoProperties = new HashMap<String, QuerySchema.PropertyInfo>();
        for (ManagedMethod managedMethod : managedObjectMethods) {
            boolean isMethodSuitableForModelProperty = managedMethod.getResult() != null && managedMethod.getParameters().length == 0;
            if (!isMethodSuitableForModelProperty) continue;
            String methodName = managedMethod.getName();
            String methodQueryPropery = MethodNameToQueryPropertyConverter.toMethodQueryProperty(methodName);
            modelInfoProperties.put(methodQueryPropery, QuerySchema.PropertyInfo.forNonFilterableProperty());
        }
        return new QuerySchema.ModelInfo(modelInfoProperties);
    }
}

