/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.mo;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.mo.MethodNameToQueryPropertyConverter;
import com.vmware.ph.phservice.provider.vimcommon.mo.MoReader;
import com.vmware.ph.phservice.provider.vimcommon.mo.MoTypesProvider;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MoMethodDataProvider
implements DataProvider {
    private final MoReader _managedObjectReader;
    private final MoTypesProvider _managedObjectTypesProvider;
    private final VmodlTypeMap _vmodlTypeMap;
    private final VmodlVersion _vmodlVersion;
    private QuerySchema _querySchema;

    public MoMethodDataProvider(MoReader managedObjectReader, MoTypesProvider managedObjectTypesProvider, VmodlTypeMap vmodlTypeMap, VmodlVersion targetVmodlVersion) {
        this._managedObjectReader = managedObjectReader;
        this._managedObjectTypesProvider = managedObjectTypesProvider;
        this._vmodlTypeMap = vmodlTypeMap;
        this._vmodlVersion = targetVmodlVersion;
    }

    public QuerySchema getSchema() {
        if (this._querySchema == null) {
            List<ManagedObjectType> managedObjectTypes = this._managedObjectTypesProvider.getManagedObjectTypes();
            this._querySchema = this.createMethodQuerySchema(managedObjectTypes);
        }
        return this._querySchema;
    }

    public ResultSet executeQuery(Query query) {
        ManagedObject targetManagedObject = this.getManagedObject(query.getResourceModels());
        URI modelKey = MoMethodDataProvider.createModelKey(targetManagedObject);
        LinkedList<Object> queryPropertyValues = MoMethodDataProvider.getQueryPropertyValues(targetManagedObject, modelKey, query.getProperties());
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)query.getProperties());
        resultSetBuilder.item((Object)modelKey, queryPropertyValues);
        return resultSetBuilder.build();
    }

    private QuerySchema createMethodQuerySchema(List<ManagedObjectType> managedObjectTypes) {
        Map<String, QuerySchema.ModelInfo> modelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertManagedObjectTypeMethodsToWsdlNameModelInfos(managedObjectTypes, this._vmodlVersion);
        return QuerySchema.forModels(modelInfo);
    }

    private ManagedObject getManagedObject(Collection<String> resourceModels) {
        if (resourceModels == null || resourceModels.isEmpty()) {
            throw new IllegalArgumentException("Query doesn't contain a resource model.");
        }
        String resourceModel = resourceModels.iterator().next();
        ManagedObjectType managedObjectType = (ManagedObjectType)this._vmodlTypeMap.getVmodlType(resourceModel);
        return this._managedObjectReader.getManagedObject((VmodlType)managedObjectType);
    }

    private static URI createModelKey(ManagedObject managedObject) {
        ManagedObjectReference moRef = managedObject._getRef();
        URI modelKey = VimDataProviderUtil.createModelKey(moRef.getType(), moRef.getServerGuid());
        return modelKey;
    }

    private static LinkedList<Object> getQueryPropertyValues(ManagedObject managedObject, URI modelKey, List<String> queryProperties) {
        List<String> nonQualifiedQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(queryProperties);
        List<String> methodNames = MethodNameToQueryPropertyConverter.toMethodNames(nonQualifiedQueryProperties);
        Map<String, Object> invokedMethodsValues = VimDataProviderUtil.getMethodInvocationReturnValues(managedObject, methodNames);
        LinkedList<Object> propertyValues = new LinkedList<Object>(invokedMethodsValues.values());
        propertyValues.add(0, modelKey);
        return propertyValues;
    }
}

