/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.vc.pc;

import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.view.ViewManager;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class PropertyCollectorReader {
    private static final int BATCH_SIZE = 250;
    private static final PropertyCollector.RetrieveOptions RETRIEVE_OPTIONS = new PropertyCollector.RetrieveOptions();
    private final VcClient _vcClient;
    private PropertyCollector _pc;

    public PropertyCollectorReader(VcClient vcClient) {
        this._vcClient = vcClient;
    }

    public ManagedObjectReference createContainerView() {
        ViewManager viewManager = (ViewManager)this._vcClient.createMo(this._vcClient.getServiceInstanceContent().viewManager);
        ManagedObjectReference containerViewMoRef = viewManager.createContainerView(this._vcClient.getServiceInstanceContent().getRootFolder(), null, true);
        return containerViewMoRef;
    }

    public List<PcResourceItem> retrieveContent(PropertyCollector.FilterSpec pcFilterSpec, List<String> pcPropertyNames, int offset, int limit) throws InvalidProperty {
        List<PcResourceItem> pcResult = this.retrieveContentInt(pcFilterSpec, pcPropertyNames, offset, limit, new PcRetrieveResultToPcResourceItemsConverter(){

            @Override
            public List<PcResourceItem> convert(PropertyCollector.RetrieveResult pcRetrieveResult, List<String> pcPropertyNames) {
                List result = PropertyCollectorReader.this.convertPcResultToPcResourceItems(pcRetrieveResult, pcPropertyNames);
                return result;
            }
        });
        return pcResult;
    }

    private List<PcResourceItem> retrieveContentInt(PropertyCollector.FilterSpec filterSpec, List<String> pcPropertyNames, int offset, int limit, PcRetrieveResultToPcResourceItemsConverter converter) throws InvalidProperty {
        if (this._pc == null) {
            this._pc = (PropertyCollector)this._vcClient.createMo(this._vcClient.getServiceInstanceContent().propertyCollector);
        }
        ArrayList<PcResourceItem> pcResult = new ArrayList<PcResourceItem>();
        if (filterSpec == null) {
            return pcResult;
        }
        int itemsStartOffset = 0;
        PropertyCollector.RetrieveResult pcChunkRetrieveResult = this._pc.retrievePropertiesEx(new PropertyCollector.FilterSpec[]{filterSpec}, RETRIEVE_OPTIONS);
        while (pcChunkRetrieveResult != null) {
            List<PcResourceItem> pcChunkResourceItems = converter.convert(pcChunkRetrieveResult, pcPropertyNames);
            pcResult.addAll(PageUtil.pageWindowItems(pcChunkResourceItems, itemsStartOffset, offset, limit));
            if (limit > 0 && pcResult.size() >= limit) {
                pcChunkRetrieveResult = null;
                continue;
            }
            if (pcChunkRetrieveResult.token == null) {
                pcChunkRetrieveResult = null;
                continue;
            }
            itemsStartOffset += pcChunkResourceItems.size();
            pcChunkRetrieveResult = this._pc.continueRetrievePropertiesEx(pcChunkRetrieveResult.token);
        }
        return pcResult;
    }

    private List<PcResourceItem> convertPcResultToPcResourceItems(PropertyCollector.RetrieveResult pcResult, List<String> pcPropertyNames) {
        if (pcResult == null) {
            return new ArrayList<PcResourceItem>(0);
        }
        ArrayList<PcResourceItem> resourceItems = new ArrayList<PcResourceItem>();
        for (PropertyCollector.ObjectContent pcResultObjectContent : pcResult.objects) {
            PcResourceItem resourceItem = this.createPcResourceItem(pcResultObjectContent, pcPropertyNames);
            if (resourceItem == null) continue;
            resourceItems.add(resourceItem);
        }
        return resourceItems;
    }

    private PcResourceItem createPcResourceItem(PropertyCollector.ObjectContent pcObjectContent, List<String> pcPropertyNames) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        ManagedObjectReference moRef = pcObjectContent.obj;
        if (moRef.getServerGuid() == null) {
            moRef.setServerGuid(this._vcClient.getServiceInstanceContent().getAbout().getInstanceUuid());
        }
        propertyValues.add(moRef);
        LinkedHashMap<String, Object> pcPropertyNameToValue = new LinkedHashMap<String, Object>();
        for (String pcPropertyName : pcPropertyNames) {
            pcPropertyNameToValue.put(pcPropertyName, null);
        }
        DynamicProperty[] resultPropertySet = pcObjectContent.getPropSet();
        if (resultPropertySet != null) {
            for (DynamicProperty dp : resultPropertySet) {
                pcPropertyNameToValue.put(dp.getName(), dp.getVal());
            }
        }
        propertyValues.addAll(pcPropertyNameToValue.values());
        PcResourceItem resourceItem = new PcResourceItem(propertyValues);
        return resourceItem;
    }

    static {
        PropertyCollectorReader.RETRIEVE_OPTIONS.maxObjects = 250;
    }

    private static interface PcRetrieveResultToPcResourceItemsConverter {
        public List<PcResourceItem> convert(PropertyCollector.RetrieveResult var1, List<String> var2) throws InvalidProperty;
    }

    public static class PcResourceItem {
        private final List<Object> _propertyValues;

        public PcResourceItem(List<Object> propertyValues) {
            this._propertyValues = propertyValues;
        }

        public List<Object> getPropertyValues() {
            return this._propertyValues;
        }
    }
}

