/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.vc.util;

import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorReader;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorUtil;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreReader {
    private static final Log _log = LogFactory.getLog(DatastoreReader.class);

    public static List<ManagedObjectReference> getDatastoreMoRefs(VcClient vcClient) {
        return DatastoreReader.getDatastoreMoRefs(vcClient, null);
    }

    public static List<ManagedObjectReference> getDatastoreMoRefs(VcClient vcClient, List<String> datastoreTypesToInclude) {
        List<PropertyCollectorReader.PcResourceItem> results;
        ArrayList<String> datastoreTypesToIncludeLc;
        block6: {
            datastoreTypesToIncludeLc = null;
            if (datastoreTypesToInclude != null && !datastoreTypesToInclude.isEmpty()) {
                datastoreTypesToIncludeLc = new ArrayList<String>(datastoreTypesToInclude.size());
                for (String datastoreType : datastoreTypesToInclude) {
                    datastoreTypesToIncludeLc.add(datastoreType.toLowerCase());
                }
            }
            List<String> dataStorePropertyNames = Arrays.asList("summary.type");
            VmodlTypeMap vmodlTypeMap = vcClient.getVmodlContext().getVmodlTypeMap();
            PropertyCollectorReader pcReader = new PropertyCollectorReader(vcClient);
            ManagedObjectReference containerViewMoRef = pcReader.createContainerView();
            List<Pair<VmodlType, String>> traversalChain = Arrays.asList(new Pair<VmodlType, String>(vmodlTypeMap.getVmodlType(ContainerView.class), "view"));
            PropertyCollector.FilterSpec dataStoresFilterSpec = PropertyCollectorUtil.createTraversableFilterSpec(vmodlTypeMap.getVmodlType("Datastore"), dataStorePropertyNames, containerViewMoRef, traversalChain, vmodlTypeMap);
            results = null;
            try {
                results = pcReader.retrieveContent(dataStoresFilterSpec, dataStorePropertyNames, 0, -1);
            }
            catch (InvalidProperty e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)"Failed to read datastores: ", (Throwable)e);
            }
        }
        LinkedList<ManagedObjectReference> datastoreMoRefs = new LinkedList<ManagedObjectReference>();
        if (results != null) {
            for (PropertyCollectorReader.PcResourceItem pcResourceItem : results) {
                ManagedObjectReference moRef = (ManagedObjectReference)pcResourceItem.getPropertyValues().get(0);
                String dataStoreType = (String)pcResourceItem.getPropertyValues().get(1);
                if (datastoreTypesToIncludeLc != null && !datastoreTypesToIncludeLc.contains(dataStoreType.toLowerCase())) continue;
                datastoreMoRefs.add(moRef);
            }
        }
        return datastoreMoRefs;
    }
}

