/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.vc.util;

import com.vmware.ph.phservice.ciscommon.ProductVersion;
import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorReader;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorUtil;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.host.ConfigInfo;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.NetCapabilities;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualNicManager;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostReader {
    private static final Log _log = LogFactory.getLog(HostReader.class);
    private final VcClient _vcClient;

    public HostReader(VcClient vcClient) {
        this._vcClient = vcClient;
    }

    public List<ManagedObjectReference> getHostMoRefs() {
        List<PropertyCollectorReader.PcResourceItem> results;
        block4: {
            List<String> hostPropertyNames = Arrays.asList("name");
            VmodlTypeMap vmodlTypeMap = this._vcClient.getVmodlContext().getVmodlTypeMap();
            PropertyCollectorReader pcReader = new PropertyCollectorReader(this._vcClient);
            ManagedObjectReference containerViewMoRef = pcReader.createContainerView();
            List<Pair<VmodlType, String>> traversalChain = Arrays.asList(new Pair<VmodlType, String>(vmodlTypeMap.getVmodlType(ContainerView.class), "view"));
            PropertyCollector.FilterSpec hostsFilterSpec = PropertyCollectorUtil.createTraversableFilterSpec(vmodlTypeMap.getVmodlType("HostSystem"), hostPropertyNames, containerViewMoRef, traversalChain, vmodlTypeMap);
            results = null;
            try {
                results = pcReader.retrieveContent(hostsFilterSpec, hostPropertyNames, 0, -1);
            }
            catch (InvalidProperty e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)"Failed to read hosts: ", (Throwable)e);
            }
        }
        LinkedList<ManagedObjectReference> hostMoRefs = new LinkedList<ManagedObjectReference>();
        if (results != null) {
            for (PropertyCollectorReader.PcResourceItem pcResourceItem : results) {
                ManagedObjectReference moRef = (ManagedObjectReference)pcResourceItem.getPropertyValues().get(0);
                hostMoRefs.add(moRef);
            }
        }
        return hostMoRefs;
    }

    public String getHostUuid(ManagedObjectReference hostMoRef) {
        Objects.requireNonNull(hostMoRef);
        HostSystem host = (HostSystem)this._vcClient.createMo(hostMoRef);
        return host.getSummary().hardware.uuid;
    }

    public ProductVersion getHostVersion(ManagedObjectReference hostMoRef) {
        Objects.requireNonNull(hostMoRef);
        HostSystem host = (HostSystem)this._vcClient.createMo(hostMoRef);
        ConfigInfo config = host.getConfig();
        AboutInfo about = config.getProduct();
        ProductVersion version = new ProductVersion(about.getVersion());
        return version;
    }

    public List<String> getManagementIps(ManagedObjectReference hostMoRef) {
        Objects.requireNonNull(hostMoRef);
        HostSystem host = (HostSystem)this._vcClient.createMo(hostMoRef);
        VirtualNic[] hostNics = this.usesServiceConsole(host) ? this.getServiceConsoleNics(host) : this.getManagmentNetworkNics(host);
        ArrayList<String> hostIpv4s = new ArrayList<String>();
        ArrayList<String> hostIpv6s = new ArrayList<String>();
        for (VirtualNic hostNic : hostNics) {
            IpConfig.IpV6Address[] ipV6Addresses;
            String ipAddress = this.getIpAddress(hostNic);
            if (ipAddress != null && !ipAddress.isEmpty()) {
                hostIpv4s.add(ipAddress);
            }
            if ((ipV6Addresses = this.getIpV6Addresses(hostNic)) == null) continue;
            for (IpConfig.IpV6Address ipV6Address : ipV6Addresses) {
                String ipv6Address = ipV6Address.getIpAddress();
                if (ipv6Address.isEmpty()) continue;
                hostIpv6s.add(ipv6Address);
            }
        }
        ArrayList<String> hostIps = new ArrayList<String>();
        hostIps.addAll(hostIpv4s);
        hostIps.addAll(hostIpv6s);
        return hostIps;
    }

    private VirtualNic[] getManagmentNetworkNics(HostSystem host) {
        ConfigManager configManager = host.getConfigManager();
        ManagedObjectReference virtualNicMoRef = configManager.getVirtualNicManager();
        VirtualNicManager vNicManager = (VirtualNicManager)this._vcClient.createMo(virtualNicMoRef);
        VirtualNic[] result = null;
        try {
            String[] selectedNics;
            VirtualNic[] candidateNics;
            VirtualNicManager.NetConfig netConfig = vNicManager.queryNetConfig(VirtualNicManager.NicType.management.toString());
            if (netConfig == null) {
                candidateNics = null;
                selectedNics = null;
            } else {
                candidateNics = netConfig.getCandidateVnic();
                selectedNics = netConfig.getSelectedVnic();
            }
            if (candidateNics == null || selectedNics == null) {
                result = null;
            } else {
                result = new VirtualNic[selectedNics.length];
                for (int i = 0; i < selectedNics.length; ++i) {
                    for (VirtualNic nic : candidateNics) {
                        if (!selectedNics[i].equals(nic.getKey())) continue;
                        result[i] = nic;
                        break;
                    }
                    assert (result[i] != null);
                }
            }
        }
        catch (HostConfigFault e) {
            String msg = "Failed querying network configuration of the host.";
            _log.error((Object)msg, (Throwable)e);
        }
        return result;
    }

    boolean usesServiceConsole(HostSystem host) {
        ConfigManager configManager = host.getConfigManager();
        ManagedObjectReference netSystemMoRef = configManager.getNetworkSystem();
        NetworkSystem netSystem = (NetworkSystem)this._vcClient.createMo(netSystemMoRef);
        NetCapabilities netCapabilities = netSystem.getCapabilities();
        return netCapabilities.isUsesServiceConsoleNic();
    }

    VirtualNic[] getServiceConsoleNics(HostSystem host) {
        ConfigInfo info = host.getConfig();
        NetworkInfo networkInfo = info.getNetwork();
        return networkInfo.getConsoleVnic();
    }

    private String getIpAddress(VirtualNic hostNic) {
        IpConfig ipConfig = hostNic.getSpec().getIp();
        if (ipConfig == null) {
            return null;
        }
        return ipConfig.getIpAddress();
    }

    private IpConfig.IpV6Address[] getIpV6Addresses(VirtualNic hostNic) {
        IpConfig ipConfig = hostNic.getSpec().getIp();
        if (ipConfig == null) {
            return null;
        }
        IpConfig.IpV6AddressConfiguration ipV6Config = ipConfig.getIpV6Config();
        if (ipV6Config == null) {
            return null;
        }
        return ipV6Config.getIpV6Address();
    }
}

