/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.vc.util;

import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorReader;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorUtil;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualMachineReader {
    private static final Log _log = LogFactory.getLog(VirtualMachineReader.class);

    public static List<ManagedObjectReference> getVmMoRefs(VcClient vcClient, int queryOffset, int quertLimit) {
        List<PropertyCollectorReader.PcResourceItem> results;
        block4: {
            List<String> vmPropertyNames = Arrays.asList("config.name");
            VmodlTypeMap vmodlTypeMap = vcClient.getVmodlContext().getVmodlTypeMap();
            PropertyCollectorReader pcReader = new PropertyCollectorReader(vcClient);
            ManagedObjectReference containerViewMoRef = pcReader.createContainerView();
            List<Pair<VmodlType, String>> traversalChain = Arrays.asList(new Pair<VmodlType, String>(vmodlTypeMap.getVmodlType(ContainerView.class), "view"));
            PropertyCollector.FilterSpec vmFilterSpec = PropertyCollectorUtil.createTraversableFilterSpec(vmodlTypeMap.getVmodlType("VirtualMachine"), vmPropertyNames, containerViewMoRef, traversalChain, vmodlTypeMap);
            results = null;
            try {
                results = pcReader.retrieveContent(vmFilterSpec, vmPropertyNames, queryOffset, quertLimit);
            }
            catch (InvalidProperty e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)"Failed to read VirtualMachines: ", (Throwable)e);
            }
        }
        List<ManagedObjectReference> vmMoRefs = Collections.emptyList();
        if (results != null) {
            vmMoRefs = new ArrayList<ManagedObjectReference>(results.size());
            for (PropertyCollectorReader.PcResourceItem pcResourceItem : results) {
                ManagedObjectReference moRef = (ManagedObjectReference)pcResourceItem.getPropertyValues().get(0);
                vmMoRefs.add(moRef);
            }
        }
        return vmMoRefs;
    }
}

