/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INIConfiguration {
    private static final Pattern _section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private static final Pattern _keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
    private Map<String, Map<String, String>> _entries = new HashMap<String, Map<String, String>>();

    public void load(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        String section = null;
        while ((line = br.readLine()) != null) {
            Matcher keyValueMatcher;
            Matcher sectionMatcher = _section.matcher(line);
            if (sectionMatcher.matches()) {
                section = sectionMatcher.group(1).trim();
                continue;
            }
            if (section == null || !(keyValueMatcher = _keyValue.matcher(line)).matches()) continue;
            String key = keyValueMatcher.group(1).trim();
            String value = keyValueMatcher.group(2).trim();
            String sectionLc = section.toLowerCase();
            String keyLc = key.toLowerCase();
            Map<String, String> map = this._entries.get(sectionLc);
            if (map == null) {
                map = new HashMap<String, String>();
                this._entries.put(sectionLc, map);
            }
            map.put(keyLc, value);
        }
    }

    public String getValue(String section, String key) {
        String sectionLc = section.toLowerCase();
        String keyLc = key.toLowerCase();
        Map<String, String> map = this._entries.get(sectionLc);
        if (map == null) {
            return null;
        }
        return map.get(keyLc);
    }
}

