/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.vapicommon.client;

import com.vmware.ph.phservice.vapicommon.client.SecurityContextProvider;
import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.cis.authn.ProtocolFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vapi.std.errors.Unauthorized;
import java.net.URI;
import java.security.KeyStore;

public class VapiClient
implements AutoCloseable {
    private final ProtocolConnection _connection;
    private final StubFactory _stubFactory;
    private final StubConfiguration _stubConfiguration;

    public VapiClient(URI apiUri, KeyStore trustStore, SecurityContextProvider securityContextProvider) {
        this._connection = VapiClient.createVapiClient(apiUri, trustStore);
        this._stubConfiguration = new StubConfiguration();
        this._stubConfiguration.setRetryPolicy((RetryPolicy)new AuthnRetryPolicyImpl(securityContextProvider));
        this._stubFactory = new StubFactory(this._connection.getApiProvider());
    }

    public <T extends Service> T createStub(Class<T> vapiIface) {
        return (T)this._stubFactory.createStub(vapiIface, (StubConfigurationBase)this._stubConfiguration);
    }

    @Override
    public void close() throws Exception {
        this._connection.disconnect();
    }

    private static ProtocolConnection createVapiClient(URI vmonUri, KeyStore trustStore) {
        ClientConfiguration clientConfiguration = new ClientConfiguration.Builder().getConfig();
        HttpConfiguration.SslConfiguration sslConfig = new HttpConfiguration.SslConfiguration.Builder(trustStore).getConfig();
        HttpConfiguration httpConfiguration = new HttpConfiguration.Builder().setSslConfiguration(sslConfig).getConfig();
        ProtocolFactory protocolFactory = new ProtocolFactory();
        ProtocolConnection protocolConnection = protocolFactory.getHttpConnection(vmonUri.toString(), clientConfiguration, httpConfiguration);
        return protocolConnection;
    }

    private static class AuthnRetryPolicyImpl
    implements RetryPolicy {
        private final SecurityContextProvider _securityContextProvider;

        public AuthnRetryPolicyImpl(SecurityContextProvider securityContextProvider) {
            this._securityContextProvider = securityContextProvider;
        }

        public RetryPolicy.RetrySpec onInvocationError(RuntimeException error, RetryPolicy.RetryContext retryContext, int invocationAttempt) {
            if (error instanceof Unauthenticated || error instanceof Unauthorized) {
                ExecutionContext.SecurityContext securityContext;
                try {
                    securityContext = this._securityContextProvider.getSecurityContext();
                }
                catch (Exception e) {
                    return null;
                }
                ExecutionContext newExecutionContext = new ExecutionContext(retryContext.getExecutionContext().retrieveApplicationData(), securityContext);
                InvocationConfig invocationConfig = new InvocationConfig(newExecutionContext);
                RetryPolicy.RetrySpec retrySpec = new RetryPolicy.RetrySpec(invocationConfig);
                return retrySpec;
            }
            return null;
        }
    }
}

