/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.vmomicommon.server;

import com.vmware.ph.phservice.vmomicommon.VersionFinder;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.BodyHandler;
import com.vmware.vim.vmomi.server.impl.BodyHandlerImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BodyHandlerFactory {
    private VersionFinder _versionFinder;
    private List<VmodlVersion> _versions;
    private AdapterServer _adapterServer;
    private VmodlContext _vmodlContext;

    public BodyHandlerFactory(VersionFinder versionFinder, List<VmodlVersion> versions, AdapterServer adapterServer, VmodlContext vmodlContext) {
        this._versionFinder = versionFinder;
        this._versions = versions;
        this._adapterServer = adapterServer;
        this._vmodlContext = vmodlContext;
    }

    public List<BodyHandler> getBodyHandlers() {
        HashSet<VmodlVersion> compatibleVersions = new HashSet<VmodlVersion>();
        for (VmodlVersion version : this._versions) {
            compatibleVersions.addAll(this._versionFinder.getCompatible(version));
        }
        ArrayList<BodyHandler> result = new ArrayList<BodyHandler>();
        for (VmodlVersion version : compatibleVersions) {
            BodyHandlerImpl bodyHandler = new BodyHandlerImpl(version, this._adapterServer, this._vmodlContext);
            result.add((BodyHandler)bodyHandler);
        }
        return result;
    }
}

