/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.sso;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.json.JsonUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.security.util.Util;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.HttpRequestHandler;

public class ResetPasswordRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(ResetPasswordRequestHandler.class);
    private static final String UTF_8 = "UTF-8";
    private final SsoServiceManager _ssoServiceManager;

    public ResetPasswordRequestHandler(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
        _logger.info((Object)"instantiated");
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        SsoAdminService ssoAdminService = null;
        try {
            byte[] byArray = Base64.decodeBase64((String)httpServletRequest.getParameter("username"));
            String string = new String(byArray, UTF_8);
            byArray = Base64.decodeBase64((String)httpServletRequest.getParameter("password"));
            String string2 = new String(byArray, UTF_8);
            byArray = Base64.decodeBase64((String)httpServletRequest.getParameter("newPassword"));
            String string3 = new String(byArray, UTF_8);
            _logger.info((Object)("Reseting password for: " + string));
            ssoAdminService = this._ssoServiceManager.getAdminService(null, SsoDomain.getLocal());
            String string4 = ssoAdminService.getIdentitySourceManagementService().getSystemDomainName();
            string = this.adjustUserName(string, string4);
            ssoAdminService.getPrincipalManagementService().resetLocalUserPassword(string, string2, string3);
            _logger.info((Object)("Reseting password for: " + string + " was successful."));
            this.sendResponse(httpServletResponse, null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to reset user password", (Throwable)exception);
            this.sendResponse(httpServletResponse, null, exception);
        }
    }

    private String adjustUserName(String string, String string2) throws InvalidArgument {
        String string3 = SsoUtil.getDomainName((String)string);
        if (StringUtil.isNullOrEmpty((String)string3)) {
            return string;
        }
        if (string3.equalsIgnoreCase(string2)) {
            return SsoUtil.getUserName((String)string);
        }
        InvalidArgument invalidArgument = new InvalidArgument();
        invalidArgument.setMessage(Util.getLocalizedString("sso.resetPassword.invalidDomain", string2));
        throw invalidArgument;
    }

    private void sendResponse(HttpServletResponse httpServletResponse, Object object, Exception exception) throws IOException {
        if (exception == null) {
            String string = "{\"result\": null,\"error\": null}";
            this.writeResponse(httpServletResponse, string);
            return;
        }
        String string = "{\"result\": null,\"error\": {\"name\": %s,\"message\": %s}}";
        String string2 = JsonUtil.escape((String)exception.getClass().getCanonicalName());
        String string3 = JsonUtil.escape((String)exception.getMessage());
        String string4 = String.format(string, string2, string3);
        this.writeResponse(httpServletResponse, string4);
    }

    private void writeResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/plain;charset=UTF-8");
        httpServletResponse.setCharacterEncoding(UTF_8);
        httpServletResponse.getWriter().print(string);
    }
}

