/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.sso;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenManager;
import com.vmware.sso.tokenmgmt.impl.NonAcquiringTokenManager;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.BundleMessageSource;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.PasswordExpiredException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.SsoRuntimeException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vise.security.authentication.PrimaryAuthenticationHandler;
import com.vmware.vise.security.spring.DefaultAuthenticationException;
import com.vmware.vise.security.spring.WebAuthenticationDetails;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerConnectionException;
import com.vmware.vise.vim.lookup.LookupServiceConnectionException;
import com.vmware.vise.vim.security.sso.AsyncTokenManager;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vise.vim.security.sso.exception.SsoSspiChallenge;
import com.vmware.vsphere.client.security.sso.SsoEnablementChecker;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;

public class SsoAuthenticationHandler
implements PrimaryAuthenticationHandler {
    private static final String SSO_FAULT = "ssoFault=";
    private static final String SSO_PWD_EXP_FAULT = "ssoPwdExpFault=";
    public static final String SECURITY_FORM_SSPI_TOKEN_KEY = "j_base64SspiToken";
    private static final String SSPI_CHALLENGE_ERROR = "sspiChallenge=";
    private static final String GSS_CLIENT = "gssClient";
    private static final Log _logger = LogFactory.getLog(SsoAuthenticationHandler.class);
    private ConcurrentHashMap<Locale, BundleMessageSource> _ssoMessageBundleByLocale = new ConcurrentHashMap();
    private final SsoService _ssoService;
    private final ExecutorService _tokenAcquisitionExecutor;
    private final SsoEnablementChecker _ssoEnablementChecker;
    private final SsoSolutionUser _ssoSolutionUser;
    private final boolean _webSsoNotificationsEnabled;

    public SsoAuthenticationHandler(ConfigurationService configurationService, SsoService ssoService, ExecutorService executorService, SsoEnablementChecker ssoEnablementChecker) {
        this._ssoService = ssoService;
        this._tokenAcquisitionExecutor = executorService;
        this._ssoEnablementChecker = ssoEnablementChecker;
        this._ssoSolutionUser = SsoUtil.getSolutionUser();
        String string = configurationService.getProperty("websso.handleLogoutNotifications");
        this._webSsoNotificationsEnabled = StringUtil.parseBoolean((String)string, (boolean)false);
    }

    public void authenticate(Authentication authentication) throws Exception {
        if (!this._ssoEnablementChecker.isSsoEnabled()) {
            _logger.debug((Object)"SSO disabled, skipping SSO authentication.");
            return;
        }
        Locale locale = null;
        SsoDomain ssoDomain = SsoDomain.getLocal();
        try {
            AsyncTokenManager asyncTokenManager;
            SamlToken samlToken = this._ssoSolutionUser.getLoggedInToken(ssoDomain);
            if (samlToken == null) {
                throw new IllegalStateException("Missing solution user token for the local domain");
            }
            String string = (String)authentication.getPrincipal();
            String string2 = (String)authentication.getCredentials();
            WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)authentication.getDetails();
            String string3 = webAuthenticationDetails.getParameter(SECURITY_FORM_SSPI_TOKEN_KEY);
            HttpServletRequest httpServletRequest = webAuthenticationDetails.getRequest();
            locale = ResourceUtil.getLocale((HttpServletRequest)httpServletRequest);
            HttpSession httpSession = httpServletRequest.getSession();
            SamlToken samlToken2 = (SamlToken)httpSession.getAttribute("webSsoToken");
            TokenSpec.DelegationSpec delegationSpec = null;
            boolean bl = false;
            if (samlToken2 != null) {
                delegationSpec = new TokenSpec.DelegationSpec(samlToken2, true);
                bl = true;
            }
            TokenSpec tokenSpec = SsoUtil.buildTokenSpec((long)28800000L, delegationSpec, (boolean)bl);
            SamlToken samlToken3 = null;
            if (samlToken2 != null) {
                _logger.info((Object)"Exchanging the websso token for a Hok token.");
                asyncTokenManager = new AsyncTokenManager(this._ssoService, this._tokenAcquisitionExecutor);
                asyncTokenManager.acquireAllTokensByToken(ssoDomain, samlToken, tokenSpec, ssoDomain, null, null);
                samlToken3 = asyncTokenManager.getTokenForSsoDomain(ssoDomain).getToken();
            } else if (StringUtil.isNullOrEmpty((String)string3)) {
                string = this.formatUsername(string);
                samlToken3 = this._ssoService.acquireToken(ssoDomain, string, string2, tokenSpec);
                asyncTokenManager = new NonAcquiringTokenManager();
                asyncTokenManager.setTokenForSsoDomain(ssoDomain, ssoDomain, samlToken3);
            } else {
                _logger.info((Object)"Logging in using SSPI. Token");
                samlToken3 = this.acquireTokenBySSPI(string3, tokenSpec, httpSession);
                asyncTokenManager = new NonAcquiringTokenManager();
                asyncTokenManager.setTokenForSsoDomain(ssoDomain, ssoDomain, samlToken3);
            }
            _logger.info((Object)("New token data: start time=" + samlToken3.getStartTime() + ", expiration time=" + samlToken3.getExpirationTime() + ", conf.type=" + samlToken3.getConfirmationType()));
            this.setupSessionData(httpServletRequest, httpSession, (TokenManager)asyncTokenManager);
            if (samlToken2 != null) {
                SessionUtil.setData((String)"webSsoToken", (Object)samlToken2);
            }
            String string4 = SessionUtil.getSessionInfo((HttpSession)httpSession);
            this.storeLoginHost();
            _logger.info((Object)("SSO authentication successful for " + string4));
        }
        catch (Throwable throwable) {
            String string;
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof CertificateValidationException) {
                _logger.error((Object)"CertificateValidationException when connecting to the SSO server.", throwable2);
                string = SSO_FAULT + String.format(Util.getLocalizedString("sso.sslError", new String[0]), this.getStsUrl(ssoDomain));
            } else if (throwable2 instanceof SsoSspiChallenge) {
                SsoSspiChallenge ssoSspiChallenge = (SsoSspiChallenge)throwable2;
                _logger.info((Object)("SSO server returned a SSPI challenge. Challenge token: " + ssoSspiChallenge.getBase64Token()));
                string = SSPI_CHALLENGE_ERROR + ssoSspiChallenge.getBase64Token();
            } else if (throwable2 instanceof ServerCommunicationException) {
                _logger.error((Object)"SSO Server communication error", throwable2);
                string = SSO_FAULT + String.format(Util.getLocalizedString("sso.serverCommunicationException", new String[0]), this.getStsUrl(ssoDomain));
            } else if (throwable2 instanceof TimeSynchronizationException) {
                _logger.error((Object)"Time synchronization error", throwable2);
                string = SSO_FAULT + String.format(Util.getLocalizedString("sso.timeSynchronizationError", new String[0]), this.getStsUrl(ssoDomain));
            } else if (throwable2 instanceof SsoException || throwable2 instanceof SsoRuntimeException) {
                _logger.error((Object)"SSO error", throwable);
                String string5 = this.getLocalizedSsoErrorMessage(throwable2, locale);
                string = throwable2 instanceof PasswordExpiredException ? SSO_PWD_EXP_FAULT + string5 : SSO_FAULT + string5;
            } else if (throwable2 instanceof LookupServiceConnectionException || throwable2 instanceof ComponentManagerConnectionException || throwable2 instanceof ComponentManagerFault) {
                _logger.error((Object)"LS/CM error", throwable);
                String string6 = throwable2.getMessage();
                string = SSO_FAULT + string6;
            } else {
                _logger.error((Object)"Error during authentication", throwable);
                string = SSO_FAULT + String.format(Util.getLocalizedString("sso.connectionError", new String[0]), this.getStsUrl(ssoDomain));
            }
            throw new DefaultAuthenticationException(string, null);
        }
    }

    private String getStsUrl(SsoDomain ssoDomain) throws Exception {
        Map map = this._ssoService.getServerInfos();
        SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo((Map)map, (SsoDomain)ssoDomain);
        return ssoServerInfo.getStsUrl();
    }

    public void logout(HttpSession httpSession) {
    }

    public void successfulAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
    }

    public static String stripSsoErrorPrefix(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.startsWith(SSO_FAULT)) {
            return string.substring(SSO_FAULT.length());
        }
        if (string.startsWith(SSO_PWD_EXP_FAULT)) {
            return string.substring(SSO_PWD_EXP_FAULT.length());
        }
        if (string.startsWith(SSPI_CHALLENGE_ERROR)) {
            return string.substring(SSPI_CHALLENGE_ERROR.length());
        }
        return string;
    }

    private String formatUsername(String string) {
        int n = string.indexOf("\\");
        if (n == -1) {
            return string;
        }
        _logger.debug((Object)("Username is in netbios format - " + string));
        string = string.substring(n + 1) + "@" + string.substring(0, n);
        _logger.debug((Object)("Username is now transformed to UPN format - " + string));
        return string;
    }

    private String getLocalizedSsoErrorMessage(Throwable throwable, Locale locale) {
        BundleMessageSource bundleMessageSource;
        BundleMessageSource bundleMessageSource2 = this._ssoMessageBundleByLocale.get(locale);
        if (bundleMessageSource2 == null && (bundleMessageSource = this._ssoMessageBundleByLocale.putIfAbsent(locale, bundleMessageSource2 = new BundleMessageSource(locale))) != null) {
            bundleMessageSource2 = bundleMessageSource;
        }
        if (throwable instanceof SsoException) {
            return bundleMessageSource2.createMessage((SsoException)throwable);
        }
        if (throwable instanceof SsoRuntimeException) {
            return bundleMessageSource2.createMessage((SsoRuntimeException)throwable);
        }
        _logger.warn((Object)"Cannot localize the exception, it is not a valid SSO exception type.");
        return throwable.getMessage();
    }

    private SamlToken acquireTokenBySSPI(String string, TokenSpec tokenSpec, HttpSession httpSession) throws SsoServiceException {
        GssNegotiationClient gssNegotiationClient = (GssNegotiationClient)httpSession.getAttribute(GSS_CLIENT);
        if (gssNegotiationClient == null) {
            _logger.info((Object)"Creating gss client to initiate sspi token negotiation.");
            SsoDomain ssoDomain = SsoDomain.getLocal();
            gssNegotiationClient = this._ssoService.obtainGssNegotiationClient(ssoDomain, tokenSpec);
            httpSession.setAttribute(GSS_CLIENT, (Object)gssNegotiationClient);
        } else {
            _logger.info((Object)"Found gss client in session, will continue sspi token negotiation.");
        }
        try {
            return this._ssoService.negotiateToken(gssNegotiationClient, string);
        }
        catch (SsoServiceException ssoServiceException) {
            if (!(ssoServiceException.getCause() instanceof SsoSspiChallenge)) {
                httpSession.removeAttribute(GSS_CLIENT);
            }
            throw ssoServiceException;
        }
    }

    private void setupSessionData(HttpServletRequest httpServletRequest, HttpSession httpSession, TokenManager tokenManager) throws Exception {
        String string = null;
        if (this._webSsoNotificationsEnabled) {
            string = WebssoUtil.getWebSsoSessionIndex(httpServletRequest);
        }
        if (!StringUtil.isNullOrWhitespace(string)) {
            SessionUtil.initClientDataContainerAndAssociateSessionWithClientId((HttpSession)httpSession, (String)string);
        } else {
            SessionUtil.generateAndSaveClientId((HttpSession)httpSession);
        }
        SessionUtil.setData((String)"SSO_TOKEN_MANAGER", (Object)tokenManager, (HttpSession)httpSession, (boolean)true);
        SsoDomain ssoDomain = SsoDomain.getLocal();
        SamlToken samlToken = tokenManager.getTokenForSsoDomain(ssoDomain).getToken();
        String string2 = this.getUsername(samlToken);
        SessionUtil.setData((String)"USER_NAME", (Object)string2, (HttpSession)httpSession);
        String string3 = SessionUtil.getHashedClientId((HttpSession)httpSession);
        _logger.info((Object)("Username=" + string2 + " has clientId=" + string3 + ". Use that clientId to track user activities below."));
    }

    private void storeLoginHost() {
        try {
            SsoDomain ssoDomain = SsoDomain.getLocal();
            Map map = this._ssoService.getServerInfos();
            SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo((Map)map, (SsoDomain)ssoDomain);
            String string = ssoServerInfo.getStsUri().getHost();
            SessionUtil.setData((String)"ssoServerHost", (Object)string);
        }
        catch (Exception exception) {
            _logger.warn((Object)"Cannot store login host", (Throwable)exception);
        }
    }

    private String getUsername(SamlToken samlToken) {
        PrincipalId principalId = samlToken.getSubject();
        String string = String.format("%1s@%2s", principalId.getName(), principalId.getDomain());
        return string;
    }
}

