/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.sso;

import com.google.common.base.Preconditions;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.AutoCloseable;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.LoggingRejectedExecutionHandler;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.security.sso.SsoEnablementChecker;
import com.vmware.vsphere.client.security.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoTokenLifetimeManager
implements UserSessionListener,
AutoCloseable {
    private final SsoService _ssoService;
    private final SsoEnablementChecker _ssoEnablementChecker;
    private final long _ssoTokenLifetimeSecs;
    private final ThreadFactory _schedulerThreadFactory = new WorkerThreadFactory("SsoTokenRenewalScheduler");
    private final ScheduledThreadPoolExecutor _renewTokenScheduler = new ScheduledThreadPoolExecutor(3, this._schedulerThreadFactory){

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> runnableScheduledFuture) {
            SsoTokenRenewerScheduledTask ssoTokenRenewerScheduledTask = (SsoTokenRenewerScheduledTask)runnable;
            String string = ssoTokenRenewerScheduledTask.getClientId();
            String string2 = SessionUtil.getHashedClientId((String)string);
            return new RunnableScheduledFutureWrapper<V>(runnableScheduledFuture, string, string2);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            RunnableScheduledFutureWrapper runnableScheduledFutureWrapper = (RunnableScheduledFutureWrapper)runnable;
            String string = runnableScheduledFutureWrapper.getClientId();
            SsoTokenLifetimeManager.this._sessionManager.cleanupFinishedTasks(string);
        }
    };
    private static final String SSO_TOKEN_RENEWAL_EXECUTOR_POOL_NAME = "SsoTokenRenewalExecutor";
    private final ThreadFactory _executorThreadFactory = new WorkerThreadFactory("SsoTokenRenewalExecutor");
    private final ThreadPoolExecutor _renewTokenExecutor = ThreadPoolFactory.newFlexibleThreadPool((int)0, (int)Integer.MAX_VALUE, (ThreadFactory)this._executorThreadFactory, (RejectedExecutionHandler)new LoggingRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy(), "SsoTokenRenewalExecutor"));
    private static final Log _logger = LogFactory.getLog(SsoTokenLifetimeManager.class);
    private static final long THIRTY_SECONDS = 30000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_MINUTE_AND_A_HALF = 90000L;
    private static final long TWO_MINUTES = 120000L;
    private static final long FIVE_MINUTES = 300000L;
    private static final long TEN_MINUTES = 600000L;
    private final SessionManager _sessionManager = new SessionManager();

    public SsoTokenLifetimeManager(SsoService ssoService, SsoEnablementChecker ssoEnablementChecker) {
        this(ssoService, ssoEnablementChecker, 28800000L, TimeUnit.MILLISECONDS);
    }

    public SsoTokenLifetimeManager(SsoService ssoService, SsoEnablementChecker ssoEnablementChecker, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{ssoService, ssoEnablementChecker});
        Validate.isTrue((l > 0L ? 1 : 0) != 0);
        Validate.notNull((Object)((Object)timeUnit));
        this._ssoService = ssoService;
        this._ssoEnablementChecker = ssoEnablementChecker;
        this._renewTokenScheduler.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this._renewTokenScheduler.allowCoreThreadTimeOut(true);
        this._ssoTokenLifetimeSecs = timeUnit.toSeconds(l);
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        if (!this._ssoEnablementChecker.isSsoEnabled()) {
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        SessionUtil.HashedSessionInfo hashedSessionInfo = SessionUtil.getSessionInfoObject((HttpSession)httpSession);
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            String string2 = ExceptionUtil.getCurrentStackTrace();
            _logger.error((Object)("The session is not associated with a clientId\n" + string2));
            throw new IllegalStateException("The session is not associated with a clientId");
        }
        Map map = AuthSessionUtil.getAllSsoTokenExs((String)string);
        if (map.isEmpty()) {
            _logger.warn((Object)("No tokens exist for " + hashedSessionInfo + ". Will not start a token renewal job."));
            throw new IllegalArgumentException(Util.getLocalizedString("sso.session.invalid", new String[0]));
        }
        String string3 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
        _logger.info((Object)("Registering session: " + string3));
        try {
            this._sessionManager.startSession(string);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failure while executing startSession", (Throwable)exception);
        }
        try {
            HashSet<TokenEx> hashSet = new HashSet<TokenEx>();
            for (Map.Entry tokenEx : map.entrySet()) {
                TokenEx tokenEx2;
                SsoDomain ssoDomain;
                SsoDomain ssoDomain2 = (SsoDomain)tokenEx.getKey();
                if (!ssoDomain2.equals((Object)(ssoDomain = (tokenEx2 = (TokenEx)tokenEx.getValue()).getIssuerSsoDomain()))) continue;
                hashSet.add(tokenEx2);
            }
            for (TokenEx tokenEx : hashSet) {
                this.scheduleTokenRenewal(string, hashedSessionInfo, tokenEx);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Failure while scheduling token renewal", (Throwable)exception);
        }
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        try {
            if (!this._ssoEnablementChecker.isSsoEnabled()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        String string = SessionUtil.getSessionInfo((HttpSession)httpSession);
        String string2 = SessionUtil.getClientId((HttpSession)httpSession);
        _logger.info((Object)("Revoking session: " + string));
        try {
            this._sessionManager.endSession(string2);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failure while executing endSession: " + string), (Throwable)exception);
        }
    }

    public void close() {
        this._renewTokenScheduler.shutdownNow();
        this._renewTokenExecutor.shutdownNow();
    }

    private void scheduleTokenRenewal(String string, SessionUtil.HashedSessionInfo hashedSessionInfo, TokenEx tokenEx) {
        SamlToken samlToken = tokenEx.getToken();
        long l = SsoTokenLifetimeManager.getTimeToExpiration(samlToken);
        long l2 = SsoTokenLifetimeManager.getTokenRenewalTime(l, hashedSessionInfo);
        this.scheduleTokenRenewal(string, hashedSessionInfo, tokenEx, l2, TimeUnit.MILLISECONDS);
    }

    private void scheduleTokenRenewal(String string, SessionUtil.HashedSessionInfo hashedSessionInfo, TokenEx tokenEx, long l, TimeUnit timeUnit) {
        String string2;
        assert (string != null);
        assert (tokenEx != null);
        if (hashedSessionInfo == null) {
            string2 = SessionUtil.getHashedClientId();
            hashedSessionInfo = new SessionUtil.HashedSessionInfo(null, string2);
        }
        string2 = tokenEx.getIssuerSsoDomain();
        SsoTokenRenewerScheduledTask ssoTokenRenewerScheduledTask = new SsoTokenRenewerScheduledTask(string, hashedSessionInfo, (SsoDomain)string2);
        SamlToken samlToken = tokenEx.getToken();
        ScheduledFuture<?> scheduledFuture = this._renewTokenScheduler.schedule(ssoTokenRenewerScheduledTask, l, timeUnit);
        this._sessionManager.addRenewalTask(string, scheduledFuture);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hashedSessionInfo);
        stringBuilder.append(", Token expiration time: ");
        stringBuilder.append(samlToken.getExpirationTime());
        stringBuilder.append('\n');
        stringBuilder.append("Token renewal scheduled approximately for: ");
        stringBuilder.append(new Date(new Date().getTime() + l));
        _logger.info((Object)stringBuilder);
    }

    private static long getTimeToExpiration(SamlToken samlToken) {
        Date date = samlToken.getExpirationTime();
        long l = System.currentTimeMillis();
        long l2 = date.getTime() - l;
        return l2;
    }

    private static long getTokenRenewalTime(long l, SessionUtil.HashedSessionInfo hashedSessionInfo) {
        if (l < 30000L) {
            _logger.error((Object)("Token has less than 30 seconds left. Scheduling immediate renewal. " + hashedSessionInfo));
            return 0L;
        }
        if (l < 60000L) {
            _logger.warn((Object)("Token has less than 1 minute left. Scheduling immediate renewal. " + hashedSessionInfo));
            return 0L;
        }
        if (l < 120000L) {
            _logger.warn((Object)("Token has less than 2 minutes left. " + hashedSessionInfo));
            return l - 60000L;
        }
        if (l < 300000L) {
            _logger.warn((Object)("Token has less than 5 minutes left. " + hashedSessionInfo));
            return l - 90000L;
        }
        if (l < 600000L) {
            _logger.warn((Object)("Token has less than 10 minutes left. " + hashedSessionInfo));
            return l - 120000L;
        }
        return l - 300000L;
    }

    private static class RunnableScheduledFutureWrapper<T>
    implements RunnableScheduledFuture<T> {
        private final RunnableScheduledFuture<T> _future;
        private final String _clientId;
        private final String _hashedClientId;

        public RunnableScheduledFutureWrapper(RunnableScheduledFuture<T> runnableScheduledFuture, String string, String string2) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{runnableScheduledFuture, string, string2});
            this._future = runnableScheduledFuture;
            this._clientId = string;
            this._hashedClientId = string2;
        }

        public String getClientId() {
            return this._clientId;
        }

        public String getHashedClientId() {
            return this._hashedClientId;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return this._future.getDelay(timeUnit);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return this._future.compareTo(delayed);
        }

        @Override
        public boolean cancel(boolean bl) {
            return this._future.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this._future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)this._future.get();
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this._future.get(l, timeUnit);
        }

        @Override
        public void run() {
            this._future.run();
        }

        @Override
        public boolean isPeriodic() {
            return this._future.isPeriodic();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object instanceof RunnableScheduledFutureWrapper) {
                RunnableScheduledFutureWrapper runnableScheduledFutureWrapper = (RunnableScheduledFutureWrapper)object;
                boolean bl = this._future.equals(runnableScheduledFutureWrapper._future);
                return bl;
            }
            if (object instanceof ScheduledFuture) {
                ScheduledFuture scheduledFuture = (ScheduledFuture)object;
                boolean bl = this._future.equals(scheduledFuture);
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return this._future.hashCode();
        }
    }

    private static class SessionManager {
        private final ConcurrentMap<String, CopyOnWriteArraySet<ScheduledFuture<?>>> _tokenRenewalTasksByClientId = new ConcurrentHashMap();
        private static final boolean CANCEL_RUNNING_TASKS = true;

        private SessionManager() {
        }

        void startSession(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"clientId is null");
            CopyOnWriteArraySet copyOnWriteArraySet = new CopyOnWriteArraySet();
            this._tokenRenewalTasksByClientId.put(string, copyOnWriteArraySet);
        }

        void endSession(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"clientId is null");
            Set set = (Set)this._tokenRenewalTasksByClientId.remove(string);
            if (set == null) {
                String string2 = SessionUtil.getHashedClientId((String)string);
                _logger.warn((Object)("Renewal tasks is null: clientId " + string2));
                return;
            }
            for (Future future : set) {
                future.cancel(true);
            }
        }

        <T> void addRenewalTask(String string, ScheduledFuture<T> scheduledFuture) {
            Preconditions.checkNotNull((Object)string, (Object)"clientId is null");
            Set set = (Set)this._tokenRenewalTasksByClientId.get(string);
            if (set == null) {
                scheduledFuture.cancel(true);
                return;
            }
            set.add(scheduledFuture);
        }

        void cleanupFinishedTasks(String string) {
            int n;
            Preconditions.checkNotNull((Object)string, (Object)"clientId is null");
            CopyOnWriteArraySet copyOnWriteArraySet = (CopyOnWriteArraySet)this._tokenRenewalTasksByClientId.get(string);
            if (copyOnWriteArraySet == null || (n = copyOnWriteArraySet.size()) == 0) {
                return;
            }
            ArrayList<ScheduledFuture> arrayList = new ArrayList<ScheduledFuture>(n);
            for (ScheduledFuture scheduledFuture : copyOnWriteArraySet) {
                if (!scheduledFuture.isDone()) continue;
                arrayList.add(scheduledFuture);
            }
            if (arrayList.size() > 0) {
                copyOnWriteArraySet.removeAll(arrayList);
            }
        }
    }

    private class SsoTokenRenewer
    implements Runnable {
        private final String _clientId;
        private final SessionUtil.HashedSessionInfo _sessionInfo;
        private final SsoDomain _domainWhoseTokenMustBeRenewed;

        SsoTokenRenewer(String string, SessionUtil.HashedSessionInfo hashedSessionInfo, SsoDomain ssoDomain) {
            assert (string != null);
            assert (hashedSessionInfo != null);
            this._clientId = string;
            this._sessionInfo = hashedSessionInfo;
            this._domainWhoseTokenMustBeRenewed = ssoDomain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    LogUtil.putSessionInfoIntoLogContext((SessionUtil.HashedSessionInfo)this._sessionInfo);
                    _logger.info((Object)("Beginning renewal of token for " + this._sessionInfo));
                    SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)this._domainWhoseTokenMustBeRenewed, (String)this._clientId);
                    if (samlToken != null) {
                        boolean bl;
                        try {
                            samlToken = this.renewToken(this._clientId, this._sessionInfo, samlToken, this._domainWhoseTokenMustBeRenewed);
                            bl = true;
                        }
                        catch (Exception exception) {
                            SsoTokenLifetimeManager.this.scheduleTokenRenewal(this._clientId, this._sessionInfo, new TokenEx(samlToken, this._domainWhoseTokenMustBeRenewed), 5L, TimeUnit.MINUTES);
                            bl = false;
                        }
                        if (bl) {
                            SsoTokenLifetimeManager.this.scheduleTokenRenewal(this._clientId, this._sessionInfo, new TokenEx(samlToken, this._domainWhoseTokenMustBeRenewed));
                        }
                        break block11;
                    }
                    _logger.info((Object)"Token is null. Won't renew. This is probably because another session with the same clientID already logged out.");
                }
                catch (IllegalStateException illegalStateException) {
                    _logger.error((Object)("IllegalStateException while running token renewal for: " + this._sessionInfo + "\n" + illegalStateException.getMessage()), (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Failed to renew token for " + this._sessionInfo), (Throwable)exception);
                }
                finally {
                    LogUtil.removeRequestInfoFromLogContext();
                }
            }
        }

        private SamlToken renewToken(String string, SessionUtil.HashedSessionInfo hashedSessionInfo, SamlToken samlToken, SsoDomain ssoDomain) throws Exception {
            samlToken = SsoTokenLifetimeManager.this._ssoService.renewToken(ssoDomain, samlToken, SsoTokenLifetimeManager.this._ssoTokenLifetimeSecs);
            AuthSessionUtil.setSsoToken((SsoDomain)ssoDomain, (SsoDomain)ssoDomain, (SamlToken)samlToken, (String)string);
            _logger.info((Object)("Token renewed for " + hashedSessionInfo + ". Used STS of domain " + ssoDomain + " for the renewal. Token expiration time: " + samlToken.getExpirationTime()));
            return samlToken;
        }
    }

    private class SsoTokenRenewerScheduledTask
    implements Runnable {
        private final String _clientId;
        private final SessionUtil.HashedSessionInfo _sessionInfo;
        private final SsoDomain _domainWhoseTokenMustBeRenewed;

        SsoTokenRenewerScheduledTask(String string, SessionUtil.HashedSessionInfo hashedSessionInfo, SsoDomain ssoDomain) {
            Preconditions.checkNotNull((Object)string, (Object)"clientId is null");
            this._clientId = string;
            this._sessionInfo = hashedSessionInfo;
            this._domainWhoseTokenMustBeRenewed = ssoDomain;
        }

        @Override
        public void run() {
            SsoTokenRenewer ssoTokenRenewer = new SsoTokenRenewer(this._clientId, this._sessionInfo, this._domainWhoseTokenMustBeRenewed);
            SsoTokenLifetimeManager.this._renewTokenExecutor.submit(ssoTokenRenewer);
        }

        public String getClientId() {
            return this._clientId;
        }
    }
}

