/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.util;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static final String RESOURCE_BUNDLE_NAME = "SecurityService";
    private static final Log _logger = LogFactory.getLog(Util.class);

    public static String getLocalizedString(String string, String ... stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)Util.class.getClassLoader());
    }

    public static UserSession getUserSession() {
        SamlToken samlToken;
        String string;
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (!Util.isSessionUsable(httpSession)) {
            return null;
        }
        String string2 = (String)SessionUtil.getData((String)"USER_NAME", (HttpSession)httpSession);
        if (StringUtil.isNullOrEmpty((String)string2)) {
            _logger.info((Object)"getUserSession called on an inactive session.");
            return null;
        }
        UserSession userSession = new UserSession();
        userSession.userName = string2;
        HttpSession httpSession2 = SessionUtil.getHttpSession();
        userSession.clientId = string = SessionUtil.getClientId((HttpSession)httpSession2);
        Locale locale = ResourceUtil.getLocale();
        if (locale != null) {
            userSession.locale = locale.toString();
        }
        userSession.samlTokenXml = (samlToken = AuthSessionUtil.getSsoToken((SsoDomain)SsoDomain.getLocal(), (HttpSession)httpSession2)) != null ? samlToken.toXml() : null;
        return userSession;
    }

    private static boolean isSessionUsable(HttpSession httpSession) {
        if (httpSession == null) {
            _logger.info((Object)"getUserSession called on a missing session.");
            return false;
        }
        boolean bl = SessionUtil.isLogoutInitiated((HttpSession)httpSession);
        if (bl) {
            _logger.info((Object)"getUserSession called on a session that's logging out.");
            return false;
        }
        return true;
    }
}

